% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{choose_lookup}
\alias{choose_lookup}
\title{Choose lookup table}
\usage{
choose_lookup(frm, to, species = "human", verbose = TRUE)
}
\arguments{
\item{frm}{A string, the input format of TCR data. Must be one of
\code{"tenx"}, \code{"adaptive"}, \code{"adaptivev2"}, or \code{"imgt"}.}

\item{to}{A string, the output format of TCR data. Must be one of
\code{"tenx"}, \code{"adaptive"}, \code{"adaptivev2"}, or \code{"imgt"}.}

\item{species}{A string, the species. Optional; defaults to \code{"human"}.}

\item{verbose}{A boolean, whether to show messages. Optional; defaults to \code{TRUE}}
}
\value{
A string, the path to correct lookup table.
}
\description{
\code{choose_lookup()} determines which CSV lookup table to use based on the the
input format (\code{frm}) and returns the path to that file.
}
\examples{
choose_lookup("imgt", "adaptive")
}
\keyword{internal}
