% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcgaretriever_v_1_9e.R
\name{get_case_lists}
\alias{get_case_lists}
\title{Retrieve Case List Available for a Specific Cancer Study.}
\usage{
get_case_lists(csid, dryrun = FALSE)
}
\arguments{
\item{csid}{String corresponding to the Identifier of the Study of Interest}

\item{dryrun}{Logical. If TRUE, all other arguments (if any) are ignored and 
a representative example is returned as output. No Internet connection is 
required for executing the operation when `dryrun` is TRUE.}
}
\value{
Data Frame including Case List information.
}
\description{
Each study includes one or more "case lists". Each case list is a collection
of samples that were analyzed using one or more platforms/assays. 
It is possible to obtain a list of case list identifiers from cbioportal.org for a 
cancer study of interest. Identifier, name, description and category are
returned for each entry.
}
\examples{
# Set `dryrun = FALSE` (default option) in production!
blca_case_lists <- get_case_lists("blca_tcga", dryrun = TRUE)  
blca_case_lists



}
\references{
\url{https://www.data-pulse.com/dev_site/TCGAretriever/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
