\name{Genetic_Variability_Parameters_app}
\alias{Genetic_Variability_Parameters_app}
\title{Genetic Variability Parameters}
\description{
\code{Genetic_Variability_Parameters_app()} function opens an interactive and user friendly Shiny application that enables users to estimate genetic variability parameters for multi-trait experimental data based on the \strong{Randomized Block Design (RBD)}.
}
\usage{
Genetic_Variability_Parameters_app()
}
\details{
The application is designed to calculate genetic variability parameters for datasets based on the \strong{Randomized Block Design (RBD)}.

Users can upload an Excel file (.xlsx or .xls) containing data for multiple traits. After uploading the file, users need to click the "Analyze" button.

The results are displayed in a tabular format including the following parameters for each trait:

\itemize{
  \item Grand Mean
  \item Phenotypic Variance
  \item Genotypic Variance
  \item Phenotypic Coefficient of Variation (\%)
  \item Genotypic Coefficient of Variation (\%)
  \item Broad-Sense Heritability (\%)
  \item Genetic Advance
  \item Genetic Advance as Percentage of Mean (\%)
  \item Standard Error of Mean
}

\strong{The output table is downloadable in CSV format.}
}
\section{Data Format}{
The uploaded Excel file should be formatted as follows:

\itemize{
  \item First column: Replication
  \item Second column: Genotypes
  \item Subsequent columns: Trait values (e.g., DBH, PH, FW, SW, KW, OC)
}

Trait names should be concise. Example:
\itemize{
  \item DBH : Diameter at Breast Height
  \item PH : Plant Height
  \item FW : Fruit Weight
  \item SW : Seed Weight
  \item KW : Kernel Weight
  \item OC : Oil Content
}

\strong{Note:} The uploaded file name should not contain spaces. For example, use \code{Sample_Data.xlsx} instead of \code{Sample Data.xlsx}.

An example Excel file is available for download using the \code{Download Example Data} button within the application.

The example dataset includes:
\itemize{
  \item 170 genotypes
  \item 3 replications for each genotype
  \item 6 traits: DBH, PH, FW, SW, KW, OC
}
}

\value{
Opens a user-friendly interactive Shiny application for calculating genetic variability parameters from experimental data.
}

\references{
Singh, R. K., & Chaudhary, B. D. (1977). Biometrical Methods in Quantitative Genetic Analysis.\cr
Johnson, Herbert W., H. F. Robinson, and R. E. Comstock. (1955). Estimates of genetic and environmental variability in soybeans. Agronomy Journal, 47(7), 314-318.
}

\examples{

if(interactive()) Genetic_Variability_Parameters_app()
}
