% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TAG1step.R
\name{TAG1step}
\alias{TAG1step}
\title{Conducting All Steps for Building TAG Processes}
\usage{
TAG1step(y, X,
         set.initial = list(Candi.lambda= seq(from=-2, to=2,by=0.5)),
         set.TAG = list(delta.threshold = -6),
         set.TAAG = list(adj.nu = FALSE))
}
\arguments{

\item{y}{a response vector of size n, where n is the sample size.}

\item{X}{an n by p design matrix, where n is the sample size, and p is the number of input variables.}

\item{set.initial}{a list for controling other arguments in function Initial.TAG. See Initial.TAG for more detials.}

\item{set.TAG}{a list for controling other arguments in function TAG. See TAG for more detials.}

\item{set.TAAG}{a list for controling other arguments in function TAAG. See TAAG for more detials.}
}

\description{
This function combines functions initial.TAG, TAG, and TAAG together, so it generates the estimated parameters from a completed TAG process. The returned object from TAG1step is in the same format as the one returned from TAAG, so the returned object can be passed to function pred.TAAG for predictions.
}
\value{
The values returned from the function is a list containing the following components:
\item{omega}{The estimates of the weight parameters.}
\item{s}{The estimates of the length scale parameters.}
\item{nu}{The estimates of the length scale parameter \eqn{\nu}.}
\item{lambda}{The estimate of the Box-Cox transformation parameter.}
\item{eta}{The estimate of the proportion parameter.}
\item{phi}{The estimate of the multiplication factor for \eqn{\nu}, used for high dimensional data.}
\item{obj.fun}{The negative of log-unnormalized posterior value (value of the objective function)}
\item{ty}{The transformed response vector.}
\item{X}{The n by p input design matrix.}
}
\references{
Lin, L.-H. and Joseph,  V. R. (2020) "Transformation and Additivity in Gaussian Processes",\emph{Technometrics}, 62, 525-535.  DOI:10.1080/00401706.2019.1665592.

Olivier Roustant, David Ginsbourger, Yves Deville (2012). DiceKriging, DiceOptim: Two R Packages for the Analysis of Computer Experiments by Kriging-Based Metamodeling and Optimization. Journal of Statistical Software, 51, 1-55.

Dancik, GM and Dorman, KS (2008). mlegp: Statistical analysis for computer models of biological systems using R. Bioinformatics 24, 1966-1967

Wood, S.N. (2017) Generalized Additive Models: An Introduction with R (2nd edition). New York: CRC press.


}

\seealso{
 \code{\link{initial.TAG}} for other arguments that can be listed in set.initial for controling function Initial.TAG.
 \code{\link{TAG}} for other arguments that can be listed in set.TAG for controling function TAG.
 \code{\link{TAAG}} for other arguments that can be listed in set.TAAG for controling function TAAG.
 \code{\link{pred.TAAG}} for predictions.
}

\examples{
n <- 20
p <- 2
library(randtoolbox)
X <-  sobol(n, dim = p, init = TRUE, scrambling = 2, seed = 20, normal = FALSE)
y <- exp(2*sin(0.5*pi*X[,1]) + 0.5*cos(2.5*pi*X[,2]))
par.TAAG <- TAG1step(y, X)

#Predictions From TAG1step
N <- 1000 # size of testing samples
X.test <-  sobol(N, dim = p, init = TRUE, scrambling = 2, seed = 5, normal = FALSE)
ytrue  <- exp(2*sin(0.5*pi*X.test[,1]) + 0.5*cos(2.5*pi*X.test[,2]))
pre.TAAG <- pred.TAAG(par.TAAG, X.test)
mean((pre.TAAG$Prediction-ytrue)^2)
}
\keyword{Completed TAG Processes}
\keyword{OneStepTAG}
