% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_fiedler.R
\name{fiedler}
\alias{fiedler}
\title{Compute the fiedler vector of a point cloud}
\usage{
fiedler(X, normalize = TRUE)
}
\arguments{
\item{X}{An \eqn{(N\times P)} matrix of row observations.}

\item{normalize}{Logical; if \code{TRUE} (default), the Fiedler vector is
rescaled to lie in \eqn{[0,1]} by subtracting its minimum and dividing by
its range, mimicking the normalization convention in the corresponding
Python implementation. If \code{FALSE}, the raw eigenvector is returned.}
}
\value{
A numeric vector of length \eqn{N} containing the Fiedler values
  associated with each point in the input point cloud. If \code{normalize = TRUE},
  the entries are in the interval \eqn{[0,1]}.
}
\description{
Given a point cloud \eqn{X \in \mathbf{R}^{N \times P}}, this function
constructs a fully connected weighted graph using an RBF (Gaussian) kernel
with bandwidth chosen by the median heuristic, forms the unnormalized graph
Laplacian, and returns the corresponding Fiedler vector, which is the eigenvector
associated to the second smallest eigenvalue of the Laplacian.
}
\examples{
#-------------------------------------------------------------------
#                           Description
#
# Use 'iris' dataset to compute fiedler vector. 
# The dataset is visualized in R^2 using PCA
#-------------------------------------------------------------------
# load dataset
X = as.matrix(iris[,1:4])

# PCA preprocessing
X2d = X\%*\%eigen(cov(X))$vectors[,1:2]

# compute fiedler vector
fied_vec = fiedler(X2d, normalize=TRUE)

# plot 
opar <- par(no.readonly=TRUE)
plot(X2d, col=rainbow(150)[as.numeric(cut(fied_vec, breaks=150))], 
     pch=19, xlab="PC 1", ylab="PC 2",
     main="Fiedler vector on Iris dataset (PCA-reduced)")
par(opar)

}
\concept{other}
