% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvEBayes_object_S3_methods.R
\name{eyeplot_pvEBayes}
\alias{eyeplot_pvEBayes}
\title{Generate an eyeplot showing the distribution of posterior draws for
selected drugs and adverse events}
\usage{
eyeplot_pvEBayes(
  x,
  num_top_AEs = 10,
  num_top_drugs = 8,
  specified_AEs = NULL,
  specified_drugs = NULL,
  N_threshold = 1,
  text_shift = 4,
  x_lim_scalar = 1.3,
  text_size = 3,
  log_scale = FALSE
)
}
\arguments{
\item{x}{a \code{pvEBayes} object, which is the output of the function
\link{pvEBayes} or \link{pvEBayes_tune}.}

\item{num_top_AEs}{number of most significant AEs appearing in the plot. Default to
10.}

\item{num_top_drugs}{number of most significant drugs appearing in the plot. Default
to 7.}

\item{specified_AEs}{a vector of AE names that are specified to appear in the plot. If
a vector of AEs is given, argument num_top_AEs will be ignored.}

\item{specified_drugs}{a vector of drug names that are specified to appear in the plot.
If a vector of drugs is given, argument num_top_drugs will be ignored.}

\item{N_threshold}{integer greater than 0. Any AE-drug combination with
observation smaller than N_threshold will be filtered out.}

\item{text_shift}{numeric. Controls the relative position of text labels,
(e.g., "N = 1", "E = 2"). A larger value shifts the "E = 2" further away from
its original position.}

\item{x_lim_scalar}{numeric. An x-axis range scalar that ensures text labels
are appropriately included in the plot.}

\item{text_size}{numeric. Controls the size of text labels,
(e.g., "N = 1", "E = 2").}

\item{log_scale}{logical. If TRUE, the eye plot displays the posterior
distribution of \eqn{\log(\lambda_{ij})} for the selected AEs and drugs.}
}
\value{
a ggplot2 object.
}
\description{
This function creates an eyeplot to visualize the posterior distributions of
\eqn{\lambda_{ij}} for selected AEs and drugs. The plot displays
posterior median, 90 percent credible interval for each selected AE-drug
combination.
}
\examples{
fit <- pvEBayes(
  contin_table = statin2025_44, model = "general-gamma",
  alpha = 0.3, n_posterior_draws = 1000
)

AE_names <- rownames(statin2025_44)[1:6]
drug_names <- colnames(statin2025_44)[-7]

eyeplot_pvEBayes(
  x = fit
)

}
