% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eta.partial.SS.R
\name{eta.partial.SS}
\alias{eta.partial.SS}
\title{Partial Eta Squared for ANOVA from F and Sum of Squares}
\usage{
eta.partial.SS(dfm, dfe, ssm, sse, Fvalue, a = 0.05)
}
\arguments{
\item{dfm}{degrees of freedom for the model/IV/between}

\item{dfe}{degrees of freedom for the error/residual/within}

\item{ssm}{sum of squares for the model/IV/between}

\item{sse}{sum of squares for the error/residual/within}

\item{Fvalue}{F statistic}

\item{a}{significance level}
}
\value{
Provides partial eta squared with associated confidence intervals
and relevant statistics.

\item{eta}{partial eta squared effect size}
\item{etalow}{lower level confidence interval of partial eta squared}
\item{etahigh}{upper level confidence interval of partial eta squared}
\item{dfm}{degrees of freedom for the model/IV/between}
\item{dfe}{degrees of freedom for the error/resisual/within}
\item{F}{F-statistic}
\item{p}{p-value}
\item{estimate}{the eta squared statistic and confidence interval in
APA style for markdown printing}
\item{statistic}{the F-statistic in APA style for markdown printing}
}
\description{
This function displays partial eta squared from ANOVA analyses
and its non-central confidence interval based on the F distribution.
This formula works for one way and multi way designs.
}
\details{
Partial eta squared is calculated by dividing the sum of squares
of the model by the sum of the sum of squares of the model and
sum of squares of the error.

partial eta^2 = ssm / (ssm + sse)

\href{https://www.aggieerin.com/shiny-server/tests/etapss.html}{Learn more on our example page.}
}
\examples{

#The following example is derived from the "bn2_data" dataset, included
#in the MOTE library.

#Is there a difference in atheletic spending budget for different sports?
#Does that spending interact with the change in coaching staff? This data includes
#(fake) atheletic budgets for baseball, basketball, football, soccer, and volleyball teams
#with new and old coaches to determine if there are differences in
#spending across coaches and sports.

library(ez)
bn2_data$partno = 1:nrow(bn2_data)
anova_model = ezANOVA(data = bn2_data,
                      dv = money,
                      wid = partno,
                      between = .(coach, type),
                      detailed = TRUE,
                      type = 3)

#You would calculate one eta for each F-statistic.
#Here's an example for the interaction with typing in numbers.
eta.partial.SS(dfm = 4, dfe = 990,
               ssm = 338057.9, sse = 32833499,
               Fvalue = 2.548, a = .05)

#Here's an example for the interaction with code.
eta.partial.SS(dfm = anova_model$ANOVA$DFn[4],
               dfe = anova_model$ANOVA$DFd[4],
               ssm = anova_model$ANOVA$SSn[4],
               sse = anova_model$ANOVA$SSd[4],
               Fvalue =  anova_model$ANOVA$F[4],
               a = .05)
}
\keyword{ANOVA}
\keyword{effect}
\keyword{eta,}
\keyword{size,}
