test_that("100 free reaction times in splits lines", {

  skip_on_cran() # due to risk of external resources failing

  file <- "http://www.swmeets.com/Realtime/Speedo%20Champions/210803F004.htm"

  df_test <- file %>%
    read_results() %>%
    swim_parse(relay_swimmers = TRUE, splits = TRUE)

  df_standard <-
    structure(
      list(
        Place = c(
          1,
          2,
          2,
          4,
          5,
          6,
          7,
          8,
          9,
          10,
          11,
          12,
          13,
          14,
          15,
          16,
          17,
          18,
          19,
          20,
          21,
          22,
          23,
          24,
          25,
          26,
          27,
          28,
          29,
          30,
          31,
          32,
          13,
          26,
          35,
          36,
          37,
          38,
          39,
          40,
          NA,
          NA
        ),
        Name = c(
          "Tim Connery",
          "Brendan Burns",
          "Baylor Nelson",
          "Sam Stewart",
          "Jack Franzman",
          "Brady Samuels",
          "Bence Szabados",
          "James LeBuke",
          "Shaw Satterfiel",
          "Aaron Sequeira",
          "Kevin Gillooly",
          "Brandon Hamblin",
          "Tyler Roberton",
          "Aiken Do",
          "Griffin Hadley",
          "Cam Abaqueta",
          "Brendan Whitfie",
          "Jacob Wimberly",
          "Rob Alexy",
          "Tr 'v Monroe",
          "Sage Sungail",
          "Aaron Seymour",
          "Julian Smith",
          "Alexander Hazle",
          "Lucca Battaglin",
          "Harrison Powe",
          "Alex Cimera",
          "Sebastian Smith",
          "Erik Linseisen",
          "Daniel Gordon",
          "Tommy Janton",
          "Mitchell Ledfor",
          "Logan Zucker",
          "Philip Adejumo",
          "Reid Miller",
          "Karl Helmuth",
          "Lucas Calderon",
          "Nick Clark",
          "Austin Lane",
          "Andrew Garner",
          "Tommy Cope",
          "Josh Fleagle"
        ),
        Age = c(
          "18",
          "20",
          "18",
          "24",
          "22",
          "18",
          "19",
          "19",
          "19",
          "19",
          "21",
          "21",
          "17",
          "17",
          "18",
          "17",
          "16",
          "16",
          "16",
          "18",
          "17",
          "17",
          "18",
          "17",
          "15",
          "18",
          "17",
          "17",
          "17",
          "17",
          "17",
          "16",
          "18",
          "24",
          "17",
          "18",
          "18",
          "18",
          "18",
          "18",
          "23",
          "27"
        ),
        Team = c(
          "SwimMAC Carolina",
          "Indiana Swim Clu",
          "SwimMAC Carolina",
          "YMCA Hub Fins-MS",
          "Indiana Swim Clu",
          "Cardinal Communi",
          "Club Wolverine-M",
          "Club Wolverine-M",
          "Ohio State Unive",
          "Cincinnati Marli",
          "Unattached-MA",
          "Indiana Swim Clu",
          "Tampa Bay Aquati",
          "The Fish-PV",
          "Carmel Swim Club",
          "SwimMAC Carolina",
          "Lynchburg YMCA S",
          "SwimMAC Carolina",
          "Greater Somerset",
          "North Palm Beach",
          "Patriot Aquatics",
          "Georgia Coastal-",
          "Episcopal AmberJ",
          "Greenwich Ywca D",
          "Club Kick Start-",
          "SwimMAC Carolina",
          "Hudson Explorer-",
          "Patriot Swim Tea",
          "Edge Swim Club-N",
          "York YMCA-MA",
          "Western YMCA Wah",
          "Treasure Coast S",
          "SwimMAC Carolina",
          "Bulldog Swimming",
          "SwimMAC Carolina",
          "Firestone Akron-",
          "North Baltimore-",
          "North Penn Aquat",
          "Univ Pittsburgh-",
          "T2 Aquatics-FL",
          "Club Wolverine-M",
          "Unattached-OH"
        ),
        Prelims = c(
          "49.86",
          "50.49",
          "50.41",
          "50.56",
          "50.26",
          "50.61",
          "50.81",
          "50.76",
          "51.34",
          "51.54",
          "51.55",
          "51.84",
          "51.73",
          "51.98",
          "51.77",
          "51.88",
          "52.35",
          "52.03",
          "52.05",
          "52.01",
          "52.08",
          "52.38",
          "52.25",
          "52.09",
          "52.60",
          "52.46",
          "52.50",
          "52.83",
          "52.87",
          "52.84",
          "52.43",
          "52.69",
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA
        ),
        Finals = c(
          "49.36",
          "49.86",
          "49.86",
          "50.36",
          "50.50",
          "50.92",
          "51.05",
          "51.55",
          "50.71",
          "50.85",
          "50.98",
          "51.49",
          "51.73",
          "51.74",
          "52.12",
          "52.55",
          "51.52",
          "51.81",
          "51.86",
          "51.97",
          "52.01",
          "52.02",
          "52.13",
          "52.18",
          "51.55",
          "52.17",
          "52.24",
          "52.31",
          "52.37",
          "52.68",
          "52.71",
          "52.88",
          "51.77",
          "52.42",
          "52.92",
          "53.09",
          "53.64",
          "53.71",
          "53.79",
          "54.33",
          NA,
          NA
        ),
        Points = c(
          20,
          16.5,
          16.5,
          15,
          14,
          13,
          12,
          11,
          9,
          7,
          6,
          5,
          4,
          3,
          2,
          1,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA,
          NA
        ),
        DQ = c(
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          1,
          1
        ),
        Exhibition = c(
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0
        ),
        Event = c(
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle",
          "Men 100 LC Meter Freestyle"
        ),
        Reaction_Time = c(
          "0.68",
          "0.64",
          "0.67",
          "0.64",
          "0.71",
          "0.68",
          "0.66",
          "0.82",
          "0.65",
          "0.61",
          "0.61",
          "0.61",
          "0.63",
          "0.62",
          "0.69",
          "0.63",
          "0.76",
          "0.62",
          "0.66",
          "0.67",
          "0.62",
          "0.62",
          "0.65",
          "0.55",
          "0.62",
          "0.56",
          "0.58",
          "0.62",
          "0.64",
          "0.64",
          "0.65",
          "0.71",
          "0.60",
          "0.60",
          "0.66",
          "0.63",
          "0.67",
          "0.60",
          "0.54",
          "0.69",
          NA,
          NA
        ),
        Split_50 = c(
          "23.78",
          "24.22",
          "24.46",
          "24.13",
          "24.56",
          "24.21",
          "24.19",
          "24.57",
          "24.25",
          "24.59",
          "24.27",
          "24.61",
          "24.97",
          "24.95",
          "25.17",
          "25.36",
          "24.95",
          "24.92",
          "25.20",
          "24.98",
          "24.73",
          "25.60",
          "25.03",
          "24.64",
          "24.67",
          "25.03",
          "24.84",
          "24.77",
          "25.21",
          "24.91",
          "24.74",
          "25.55",
          "24.81",
          "25.16",
          "25.22",
          "25.19",
          "25.27",
          "25.08",
          "25.60",
          "25.39",
          NA,
          NA
        ),
        Split_100 = c(
          "25.58",
          "25.64",
          "25.40",
          "26.23",
          "25.94",
          "26.71",
          "26.86",
          "26.98",
          "26.46",
          "26.26",
          "26.71",
          "26.88",
          "26.76",
          "26.79",
          "26.95",
          "27.19",
          "26.57",
          "26.89",
          "26.66",
          "26.99",
          "27.28",
          "26.42",
          "27.10",
          "27.54",
          "26.88",
          "27.14",
          "27.40",
          "27.54",
          "27.16",
          "27.77",
          "27.97",
          "27.33",
          "26.96",
          "27.26",
          "27.70",
          "27.90",
          "28.37",
          "28.63",
          "28.19",
          "28.94", NA, NA)), row.names = c(NA, -42L), class = "data.frame")

  expect_equivalent(df_test, df_standard)
})

test_that("NYS weird reaction times for relays", {

  skip_on_cran() # due to risk of external resources failing

  file <- "http://www.nyhsswim.com/Results/Boys/2020/NYS/Single.htm"

  df_test <- file %>%
    read_results() %>%
    swim_parse(relay_swimmers = TRUE, splits = TRUE)

  reaction_times_test <- df_test$Reaction_Time
  reaction_times_test <- reaction_times_test[!is.na(reaction_times_test)]

  reaction_times_standard <- c("0.71", "0.67", "0.68", "0.66", "0.74", "0.77", "0.75", "0.79",
                               "0.75", "0.72", "0.74", "0.66", "0.68", "0.75", "0.76", "0.72",
                               "0.75", "0.71", "0.72", "0.68", "0.71", "0.87", "0.73", "0.70",
                               "0.75", "0.70", "0.79", "0.70", "0.75", "0.84", "0.63", "0.72",
                               "0.67", "0.65", "0.72", "0.74", "0.69", "0.70", "0.71", "0.72",
                               "0.72", "0.70", "0.72", "0.68", "0.74", "0.73", "0.68", "0.67",
                               "0.70", "0.71", "0.69", "0.71", "0.70", "0.67", "0.67", "0.61",
                               "0.70", "0.70", "0.71", "0.77", "0.75", "0.62", "0.65", "0.69",
                               "0.80", "0.65", "0.71", "0.70", "0.75", "0.80", "0.58", "0.61",
                               "0.66", "0.61", "0.64", "0.64", "0.72", "0.64", "0.67", "0.70",
                               "0.64", "0.71", "0.67", "0.69", "0.70", "0.62", "0.67", "0.74",
                               "0.65", "0.68", "0.75", "0.65", "0.73", "0.68", "0.64", "0.75",
                               "0.71", "0.71", "0.77", "0.76", "0.70", "0.57", "0.72", "0.64",
                               "0.63", "0.66", "0.64", "0.71", "0.63", "0.70", "0.74", "0.69",
                               "0.67", "0.67", "0.69", "0.75", "0.57", "0.68", "0.78", "0.82",
                               "0.70", "0.73", "0.74", "0.82", "0.67", "0.67", "0.59", "0.70",
                               "0.77", "0.66", "0.71", "0.61", "0.70", "0.74", "0.81", "0.70",
                               "0.67", "0.69", "0.67", "0.68", "0.73", "0.74", "0.65", "0.66",
                               "0.70", "0.71", "0.70", "0.72", "0.66", "0.67", "0.63", "0.65",
                               "0.67", "0.72", "0.78", "0.82", "0.65", "0.62", "0.68", "0.62",
                               "0.67", "0.69", "0.75", "0.69", "0.82", "0.79", "0.66", "0.61",
                               "0.68", "0.73", "0.73", "0.80", "0.76", "0.92", "0.74", "0.72",
                               "0.75", "0.63", "0.79", "0.73", "0.76", "0.77", "0.78", "0.77",
                               "0.62", "0.77", "0.65", "0.62", "0.81", "0.70", "0.71", "0.74",
                               "0.73", "0.72", "0.70", "0.72", "0.75", "0.69", "0.71", "0.78",
                               "0.67", "0.68", "0.73", "0.74", "0.73", "0.67", "0.65", "0.70",
                               "0.73", "0.73", "0.77", "0.75", "0.71", "0.67", "0.64", "0.69",
                               "0.70", "0.69", "0.67", "0.69", "0.63", "0.70", "0.70", "0.74",
                               "0.67", "0.66", "0.68", "0.66", "0.72", "0.71", "0.68", "0.74",
                               "0.64", "0.70", "0.66", "0.64", "0.66", "0.68", "0.75")

  expect_equivalent(reaction_times_test, reaction_times_standard)
})

