#' High dimensional genomic data on head and neck cancer
#
#' @description Head and neck cancer data \code{tibble} on head and neck cancer patients for survexpMC and survweibMC functions.
#' @usage data(headnneck)
#' @format A \code{tibble} with 13 columns which are :
#' \describe{
#' \item{Subjects}{Patients referred to as Subjects}
#' \item{OS}{Overall Survival}
#' \item{Death}{Death status for the particular subjects}
#' \item{randgrp1}{Arm of group assigned to subjects}
#' \item{gender1}{Demographic information of Subjects, i.e. Gender}
#' \item{Stratum1}{Stratum from where the sample is drawn}
#' \item{prevoi}{Categorical observation}
#' \item{Covariate_1}{Continuous observations}
#' \item{Covariate_2}{Continuous observations}
#' \item{Covariate_3}{Continuous observations}
#' \item{Covariate_4}{Continuous observations}
#' \item{Covariate_5}{Continuous observations}
#' \item{Covariate_6}{Continuous observations}}
#' @examples data(headnneck)
#'
"headnneck"
