% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpk-IVxbyx.R
\name{IVXbyX}
\alias{IVXbyX}
\title{Create x-by-x Psuedo-IV Curves}
\usage{
IVXbyX(df, corr_temp = "median", N_c)
}
\arguments{
\item{df}{Dataframe containing IV data. Typically, a raw dataframe after
filtering by current accuracy based on plot of irradiance vs. temperature.
Within this package environment, use
\code{\link{read_df_raw}} to filter the dataset and generate period index.}

\item{corr_temp}{The temperature for all I-V features to standardize to.
Pass the string "median" in order for the function to automatically
calculate the median module temperature at 1 sun irradiance and use it,
or input a number directly, the temperature unit should be Celsius.}

\item{N_c}{Number of cells in series; the total number of cells in the system.}
}
\value{
Psuedo-IV Curve data with features extracted and evaluation parameters
of fitting grouped by time periods of set length.
}
\description{
This function moves through IV curve data x-by-x,
generating psuedo IV curves and binding them together into the output.
}
\examples{
\donttest{
df <- read_df_raw(df_wbw,0.02,7)
df_full <- IVXbyX(df, corr_temp = "median", 60)
}

}
