#' @title Example 5.2 from Generalized Linear Mixed Models: Modern Concepts, Methods and Applications by Walter W. Stroup(p-164)
#' @name   Exam5.2
#' @description Exam5.2 three factor main effects only design
#' @author \enumerate{
#'          \item  Muhammad Yaseen (\email{myaseen208@@gmail.com})
#'          \item Adeela Munawar (\email{adeela.uaf@@gmail.com})
#'          }
#' @references \enumerate{
#' \item Stroup, W. W. (2012).
#'      \emph{Generalized Linear Mixed Models: Modern Concepts, Methods and Applications}.
#'        CRC Press.
#'  }
#' @seealso
#'    \code{\link{DataSet5.2}}
#'
#' @import parameters
#' @import emmeans
#'
#' @examples
#'
#' DataSet5.2$a <- factor( x = DataSet5.2$a)
#' DataSet5.2$b <- factor( x = DataSet5.2$b)
#' DataSet5.2$c <- factor(x  = DataSet5.2$c)
#'
#' ##---first adding factor a in model
#' Exam5.2.lm1 <- lm(formula = y~ a, data  = DataSet5.2)
#' summary(Exam5.2.lm1)
#' library(parameters)
#' model_parameters(Exam5.2.lm1)
#'
#' library(emmeans)
#' ##---A first
#' emmeans(object  = Exam5.2.lm1, specs = ~a)
#' contrast(emmeans(object  = Exam5.2.lm1, specs = ~a), method = "pairwise")
#' anova(object = Exam5.2.lm1)
#'
#' ##---then adding factor b in model
#' Exam5.2.lm2 <- lm(formula = y~ a + b, data  = DataSet5.2)
#' summary(Exam5.2.lm2)
#' model_parameters(Exam5.2.lm2)
#'
#' emmeans(object  = Exam5.2.lm2, specs = ~b)
#' contrast(emmeans(object  = Exam5.2.lm2, specs = ~b), method = "pairwise")
#' anova(object = Exam5.2.lm2)
#'
#' ##---then adding factor c in model
#' Exam5.2.lm3 <- lm(formula = y~ a + b + c, data = DataSet5.2)
#'
#' summary(Exam5.2.lm3)
#' model_parameters(Exam5.2.lm3)
#'
#' emmeans(object  = Exam5.2.lm3, specs = ~c)
#' contrast(emmeans(object  = Exam5.2.lm3, specs = ~c), method = "pairwise")
#' anova(object = Exam5.2.lm3)
#'
#' ##---Now Change the order and add b first in model
#' Exam5.2.lm4 <- lm(formula = y ~  b, data = DataSet5.2)
#' summary(Exam5.2.lm4)
#' model_parameters(Exam5.2.lm4)
#'
#' emmeans(object  = Exam5.2.lm4, specs = ~b)
#' contrast(emmeans(object  = Exam5.2.lm4, specs = ~b), method = "pairwise")
#' anova(object = Exam5.2.lm4)
#'
#'
#' ##---then adding factor a in model
#' Exam5.2.lm5 <- lm(formula = y ~ b + a, data  = DataSet5.2)
#' summary(Exam5.2.lm5)
#' model_parameters(Exam5.2.lm5)
#'
#' emmeans(object  = Exam5.2.lm5, specs = ~a)
#' contrast(emmeans(object  = Exam5.2.lm5, specs = ~a), method = "pairwise")
#' anova(object = Exam5.2.lm5)
#'
NULL
