% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leftlog.R
\name{leftlog}
\alias{leftlog}
\title{Finds bed intervals in a "litholog()"-like data frame}
\usage{
leftlog(i, dt, xy, warn = TRUE)
}
\arguments{
\item{i}{the id of the polygons in the "litholog()"-like data frame}

\item{dt}{the depth of the polygons in the "litholog()"-like data frame}

\item{xy}{the x values (i.e. hardness) of the polygons in the
"litholog()"-like data frame}

\item{warn}{whether you want to be annoyed}
}
\value{
a list of minima (l) and maxima (r) of boundaries corresponding to
each bed (id)
}
\description{
Determines the interval of bed boundaries at the far left of a
litholog. This is used when the welding of varying bed boundaries changes
these intervals, and that you want to use bedtext() to print the name of the
beds on the log.
}
\examples{
l <- c(0,1,2,3,4)
r <- c(1,2,3,4,5)
h   <- c(4,3,4,3,4)
i <- c("B1","B2","B3","B4","B5")
log  <- litholog(l, r, h, i)

whiteSet(xlim = c(-1,5), ylim = c(-1,6))

title("leftlog() gets the bed names in the right position")

multigons(log$i, log$xy, log$dt, lty = 3)

seg1 <- sinpoint(4, 0, 0.25, pos = 1, phase=0)
seg2 <- sinpoint(4, 0, 0.25, pos = 1, phase=1)

welded <- weldlog(log, dt = c(2,3), seg = list(seg1, seg2), add.dt = 0.5)

multigons(welded$i, welded$xy, welded$dt, lwd = 3, lty = 2, border = "red")

old.log.interval <- leftlog(log$i, log$dt, log$xy)
new.log.interval <- leftlog(welded$i, welded$dt, welded$xy)

bedtext(labels = new.log.interval$id,
        l= new.log.interval$l,
        r= new.log.interval$r,
        arg = list(col = "red"))

}
\seealso{
\code{\link{litholog}}, \code{\link{weldlog}} and
\code{\link{bedtext}}
}
