% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ffphase}
\alias{ffphase}
\title{Fast flight phase of the cube method}
\usage{
ffphase(Xbal, prob, order = TRUE)
}
\arguments{
\item{Xbal}{A matrix of size (\eqn{N} x \eqn{p}) of auxiliary variables on which the sample must be balanced.}

\item{prob}{A vector of inclusion probabilities.}

\item{order}{if the units are reordered, Default TRUE.}
}
\value{
Updated vector of \code{pik} that contains 0 and 1 for unit that are rejected or selected.
}
\description{
This function computes the flight phase of the cube method proposed by Chauvet and Tillé (2006).
}
\details{
This function implements the method proposed by (Chauvet and Tillé 2006). It recursively transforms the vector of inclusion probabilities \code{pik} into a
sample that respects the balancing equations. The algorithm stops when the null space of the sub-matrix \eqn{B} is empty.
For more information see (Chauvet and Tillé 2006).
}
\examples{
N <- 100
n <- 10
p <- 4
pik <- rep(n/N,N)
X <- cbind(pik,matrix(rgamma(N*p,4,25),ncol= p))

pikstar <- ffphase(X,pik) 
t(X/pik)\%*\%pikstar
t(X/pik)\%*\%pik
pikstar
}
\seealso{
\code{\link[sampling:samplecube]{fastflightphase}}, \code{\link[BalancedSampling:cube]{cube}}.
}
