% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balseq.R
\name{balseq}
\alias{balseq}
\title{Sequential balanced sampling}
\usage{
balseq(pik, Xaux, Xspread = NULL, rord = TRUE)
}
\arguments{
\item{pik}{A vector of inclusion probabilities.}

\item{Xaux}{A matrix of auxiliary variables. The matrix must contains the \code{pik} vector to have fixed sample size.}

\item{Xspread}{An optional matrix of spatial coordinates.}

\item{rord}{A logical variable that specify if reordering is applied. Default TRUE.}
}
\value{
Return the selected indices in 1,2,...,N
}
\description{
Selects at the same time a well-spread and a balanced sample using a sequential implementation.
}
\details{
The function selects a sample using a sequential algorithm. At the same time, it respects the balancing equations (\code{Xaux}) and select a well-spread sample (\code{Xspread}). Algorithm uses a 
linear program to satisfy the constraints.
}
\examples{
N <- 100
n <- 10
p <- 10

pik <- rep(n/N,N)

Xaux <- array(rnorm(N*p,3,1),c(N,p))

Xspread <- cbind(runif(N),runif(N)) 
Xaux <- cbind(pik,Xaux)

s <- balseq(pik,Xaux)
colSums(Xaux[s,]/as.vector(pik[s]))
colSums(Xaux)


s <- balseq(pik,Xaux,Xspread)
colSums(Xaux[s,]/as.vector(pik[s]))
colSums(Xaux)



}
\seealso{
\code{\link[BalancedSampling:lcube]{BalancedSampling:lcube}}, \code{\link[sampling:samplecube]{sampling:samplecube}}.
}
