% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_methods-GET.R
\docType{methods}
\name{getWeights}
\alias{getWeights}
\alias{getWeights,Strategy-method}
\title{Get weights from \code{Strategy}-object}
\usage{
getWeights(object, from = NULL, until = NULL, which = NULL,
  use.backtest = FALSE)

\S4method{getWeights}{Strategy}(object, from = NULL, until = NULL,
  which = NULL, use.backtest = FALSE)
}
\arguments{
\item{object}{An object of class \code{Strategy}.}

\item{from}{The date in character format \code{"yyyy-MM-dd"} or as date-object from which weights shall be returned If \code{NULL}, no restriction is made.}

\item{until}{The date in character format \code{"yyyy-MM-dd"} or as date-object until which weights shall be returned. If \code{NULL}, no restriction is made.}

\item{which}{Names or column-number of assets that should be included. If \code{NULL}, all weights are returned.}

\item{use.backtest}{If set to \code{TRUE}, the weights of the backtest are returned. Requires \code{\link{backtest}} to be  executed first.}
}
\description{
Gets the weights data of an object of class \code{Strategy} that was used within strategy calculation.
}
\examples{
##Not run:

# MA(200)-Strategy
params <- list(k=200)
myStrat.MA <- Strategy(assets=assets, strat="MA", strat.params=params)

# Get weights data from MA(200)-Strategy
getWeights(myStrat.MA, from="2015-01-01", until="2015-12-31")

##End(Not run)
}
