% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defStormsList.R
\docType{methods}
\name{getNbObs}
\alias{getNbObs}
\alias{getNbObs,storm-method}
\alias{getNbObs,stormsList-method}
\title{Getting the number of observations}
\usage{
getNbObs(s, ...)

\S4method{getNbObs}{storm}(s)

\S4method{getNbObs}{stormsList}(s, name, season = NULL)
}
\arguments{
\item{s}{\code{storm} or \code{stormsList} object.}

\item{...}{extra arguments for \code{stormsList}}

\item{name}{character. Name of the storm in capital letters.}

\item{season}{numeric. Cyclonic season of the \code{storm}. Required only
if several \code{storm} in the \code{s} have the same name. Default value is set to
\code{NULL}.}
}
\value{
numeric.
}
\description{
The getNbObs() function returns the number of observations
for a storm in a \code{storm} or \code{stormsList} object.
}
\examples{
\donttest{
#Creating a stormsDataset
sds <- defStormsDataset()

#Getting storm track data for all storms near New Caledonia
sts <- defStormsList(sds=sds, loi = "New Caledonia")

##Getting the number of observations for the tropical cyclone Niran in the sts object
getNbObs(getStorm(sts, name = "NIRAN"))
getNbObs(sts, name = "NIRAN")
}
}
