% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{asset_loader}
\alias{asset_loader}
\title{Load Asset Data.}
\usage{
asset_loader(data_path, assets, price_col)
}
\arguments{
\item{data_path}{The path to the directory containing the .csv files.}

\item{assets}{A vector of asset names to be loaded.}

\item{price_col}{The name of the price column to be selected (e.g. Open, Close, Low, High).}
}
\value{
An xts object with asset data.
}
\description{
This function reads in asset data stored in .csv format and returns a
time-series object of the asset data.
}
\note{
The \code{Date} column in the files should be of the format "\%m/\%d/\%y", that is 01/14/13 with
01 implying the month, 14 the date and 13 the year

The data to be loaded must be in .csv type and also must have the Date, Open,
Low, High and Close Prices of the assest or assests to be loaded.
}
\examples{

asset_loader(system.file("extdata", package = "StockDistFit"), c("AAPL", "TSLA"), "Close")


}
