#' AAPL stock prices from 2013-01-02 to 2023-04-30
#'
#' This dataset contains the daily stock prices of Apple Inc. (AAPL) from January 2, 2013 to April 30, 2023.
#' The data includes the open, high, low, and close prices, as well as the volume and adjusted close price.
#'
#' @format A data frame with 2,599 rows and 7 variables:
#' \describe{
#'   \item{Date}{The date of the stock prices}
#'   \item{Open}{The opening price of the stock on the given date}
#'   \item{High}{The highest price of the stock on the given date}
#'   \item{Low}{The lowest price of the stock on the given date}
#'   \item{Close}{The closing price of the stock on the given date}
#'   \item{Volume}{The trading volume of the stock on the given date}
#'   \item{Adjusted}{The adjusted closing price of the stock on the given date}
#' }
#'
#' @references
#' Data source: Yahoo Finance
#'
#' @examples
#' library(StockDistFit)
#' data(AAPL)
#' head(AAPL)
#'
#' @keywords datasets
#' @docType data
#' @name AAPL
#' @usage data(AAPL)


#' TSLA stock prices from 2013-01-02 to 2023-05-06
#'
#' This dataset contains the daily stock prices of Tesla, Inc. (TSLA) from January 2, 2013 to May 6, 2023.
#' The data includes the open, high, low, and close prices, as well as the volume and adjusted close price.
#'
#' @format A data frame with 2599 rows and 7 variables:
#' \describe{
#'   \item{Date}{The date of the stock prices}
#'   \item{Open}{The opening price of the stock on the given date}
#'   \item{High}{The highest price of the stock on the given date}
#'   \item{Low}{The lowest price of the stock on the given date}
#'   \item{Close}{The closing price of the stock on the given date}
#'   \item{Volume}{The trading volume of the stock on the given date}
#'   \item{Adjusted}{The adjusted closing price of the stock on the given date}
#' }
#'
#' @references
#' Data source: Yahoo Finance
#'
#' @examples
#' library(StockDistFit)
#' data(TSLA)
#' head(TSLA)
#'
#' @name TSLA
#' @docType data
#' @keywords datasets
#' @usage data(TSLA)


#' AMZN stock prices from 2013-01-02 to 2023-04-30
#'
#' This dataset contains the daily stock prices of Amazon.com Inc. (AMZN) from January 2, 2013 to April 30, 2023.
#' The data includes the open, high, low, and close prices, as well as the volume and adjusted close price.
#'
#' @format A data frame with 2599 rows and 7 variables:
#' \describe{
#'   \item{Date}{The date of the stock prices}
#'   \item{Open}{The opening price of the stock on the given date}
#'   \item{High}{The highest price of the stock on the given date}
#'   \item{Low}{The lowest price of the stock on the given date}
#'   \item{Close}{The closing price of the stock on the given date}
#'   \item{Volume}{The trading volume of the stock on the given date}
#'   \item{Adjusted}{The adjusted closing price of the stock on the given date}
#' }
#'
#' @references
#' Data source: Yahoo Finance
#'
#' @examples
#' library(StockDistFit)
#' data(TSLA)
#' head(TSLA)
#'
#' @name AMZN
#' @docType data
#' @keywords datasets
#' @usage data(AMZN)


#' GOOG stock prices from 2013-01-02 to 2023-04-30
#'
#' This dataset contains the daily stock prices of Alphabet Inc. (GOOG) from January 2, 2013 to April 30, 2023.
#' The data includes the open, high, low, and close prices, as well as the volume and adjusted close price.
#'
#' @format A data frame with 2599 rows and 7 variables:
#' \describe{
#'   \item{Date}{The date of the stock prices}
#'   \item{Open}{The opening price of the stock on the given date}
#'   \item{High}{The highest price of the stock on the given date}
#'   \item{Low}{The lowest price of the stock on the given date}
#'   \item{Close}{The closing price of the stock on the given date}
#'   \item{Volume}{The trading volume of the stock on the given date}
#'   \item{Adjusted}{The adjusted closing price of the stock on the given date}
#' }
#'
#' @references
#' Data source: Yahoo Finance
#'
#' @examples
#' library(StockDistFit)
#' data(TSLA)
#' head(TSLA)
#'
#' @name GOOG
#' @docType data
#' @keywords datasets
#' @usage data(GOOG)










