% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emplogitplot2.r
\name{emplogitplot2}
\alias{emplogitplot2}
\title{Empirical logit plot for one quantitative variable by categorical groups}
\usage{
emplogitplot2(formula, data = NULL, ngroups = 3, breaks = NULL,
  yes = NULL, padj = TRUE, out = FALSE, showplot = TRUE,
  showline = TRUE, ylab = "Log(Odds)", xlab = NULL,
  putlegend = "n", levelcol = NULL, pch = NULL, main = "",
  ylim = NULL, xlim = NULL, lty = NULL, lwd = 1, cex = 1)
}
\arguments{
\item{formula}{A formula of the form (binary) Response~Quantitative Predictor+Factor}

\item{data}{A dataframe}

\item{ngroups}{Number of groups to use (not needed if breaks is used), ngroups="all" uses all unique values}

\item{breaks}{A vector of endpoints for the bins (not needed if ngroups is used)}

\item{yes}{Set a value for the response to be counted for proportions (optional)}

\item{padj}{Should proportions be adjusted to avoid zero and one? (default is TRUE)}

\item{out}{Should the function return a dataframe with group and factor information? (default is FALSE)}

\item{showplot}{Show the plot? default is TRUE}

\item{showline}{Show the regression lines? default is TRUE}

\item{ylab}{Text label for the vertical axis (default is "Log(Odds)")}

\item{xlab}{Text label for the horizontal axis (default is NULL)}

\item{putlegend}{Position for the legend (default is "n" for no legend)}

\item{levelcol}{Vector of colors for the factor levels}

\item{pch}{Plot character for the dots}

\item{main}{Title for plot}

\item{ylim}{Limits for the vertical axis}

\item{xlim}{Limits for the horizontal axis}

\item{lty}{Line type (default is 1)}

\item{lwd}{Line width (default is 1)}

\item{cex}{Multiplier for plot symbols}
}
\value{
A dataframe with group information (if out=TRUE)
}
\description{
This function produces an empirical logit plot for a binary response variable and with a
single quantitative predictor variable broken down by a single categorical factor.
}
\details{
Values of the quantitative explanatory variable will be grouped into \code{ngroups}
roughly equal sized groups, unless \code{breaks} is used to determine the boundaries of the groups.
Using \code{ngroups="all"} will make each distinct value of the explanatory variable its own group \cr

We find a proportion for the binary response variable within each of the groups created from
the quantitative variable crossed with the categrical variable. To avoid problems with proportions
of zero and one, we compute an adjusted proportion with
\code{(Number yes +0.5)/(Number of cases+1)}. This is converted to an adjusted log odds
\code{log(adjp/(1-adjp))}.  What constitutes a "success" can be specified with \code{yes=}
and the proportion adjustment can be turned off (if no group proportions are likely to be zero or one)
with \code{padj=FALSE}.\cr

The function plots the log odds versus the mean of the explanatory variable within each group with different
colors for each of the categories defined by the categorical variable.
 A least square line is fit to these points within each categorical group.
 The plot can be suppressed with \code{showplot=FALSE}.\cr

 The \code{out=TRUE} option will return a dataframe with the boundaries of each group, proportion,
 adjusted proportion, mean explanatory variable, and (adjusted or unadjusted) log odds.
}
\examples{
data(MedGPA)
emplogitplot2(Acceptance~GPA+Sex,data=MedGPA)

GroupTable2=emplogitplot2(Acceptance~MCAT+Sex,ngroups=5,out=TRUE,data=MedGPA,putlegend="topleft")

emplogitplot2(Acceptance~MCAT+Sex,data=MedGPA,breaks=c(0,34.5,39.5,50.5),
              levelcol=c("red","blue"),putlegend="bottomright")
}
