% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Louis_Information.R
\name{Louis_Information}
\alias{Louis_Information}
\title{Louis_Information}
\usage{
Louis_Information(fit, stack, M, IMPUTED = NULL)
}
\arguments{
\item{fit}{object of class glm or coxph from fitting to the (weighted) stacked dataset}

\item{stack}{data frame containing stacked dataset across multiple imputations. Could have 1 or M rows for each subject with complete data. Should have M rows for each subject with imputed data. Must contain the following named columns: (1) stack$.id, which correspond to a unique identifier for each subject. This column can be easily output from MICE. (2) stack$wt, which corresponds to weights assigned to each row. Standard analysis of stacked multiple imputations should set these weights to 1 over the number of times the subject appears in the stack.}

\item{M}{number of multiple imputations}

\item{IMPUTED}{deprecated parameter, not used in current version}
}
\value{
Info, estimated information matrix accounting for within and between imputation variation
}
\description{
This function takes a dataset with stacked multiple imputations and a glm or coxph fit and estimates the corresponding information matrix accounting for the imputation uncertainty.
}
\details{
This function uses the observed information matrix principle proposed in Louis (1982) and applied to imputations in Wei and Tanner (1990). This estimator is a further extension specifically designed for analyzing stacks of multiply imputed data as proposed in Beesley and Taylor (2019) https://arxiv.org/abs/1910.04625.
}
\examples{
data(stackExample)
Info = Louis_Information(stackExample$fit, stackExample$stack, M = 50)
VARIANCE = diag(solve(Info))

}
