#' Compute Trimmed-k Mean
#'
#' This function calculates the trimmed-k mean of a numeric vector by removing the k smallest and k largest values.
#'
#' @param dat A numeric vector of data.
#' @param k An integer indicating how many smallest and largest values to trim.
#' @return The trimmed-k mean of the data. Returns NA if not enough data points.
#' @examples
#' set.seed(5400)
#' dat <- rexp(20, rate = 0.5)
#' kTrimMean(dat, k = 2)
#' @export
kTrimMean <- function(dat, k) {
  n <- length(dat)
  if (2 * k >= n) {
    warning("Not enough data to trim k smallest and largest values.")
    return(NA)
  }
  sorted <- sort(dat)
  trimmed <- sorted[(k + 1):(n - k)]
  mean(trimmed)
}