% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_Splinets.R
\docType{class}
\name{Splinets-class}
\alias{Splinets-class}
\title{The class to represent a collection of splines}
\value{
running \code{new("Splinets")} return an object that belongs to the class \code{Splinets}, with the initialization of the default
values for the fields.
}
\description{
The main class in the \code{splinets}-package used for representing a collection of splines.
}
\section{Slots}{

\describe{
\item{\code{knots}}{numeric \code{n+2} vector, a vector of n+2 knot locations presented in the increasing order and without ties;}

\item{\code{degree}}{non-negative integer, the degree of the splines, i.e. the highest degree of the polynomial;}

\item{\code{equid}}{logical, indicates if the knots are equidistant;
Some computations in the equidistant case are simpler so this information helps to account for it.}

\item{\code{supp}}{list (of matrices), \itemize{
  \item \code{length(supp)==0} -- the full support set for all splines,
  \item \code{length(supp)==N} -- support sets for \code{N} splines;
} If non-empty, a list containing \code{Nsupp x 2} matrices (of positive integers). 
If \code{Nsupp} is equal to one it should be a row matrix (not a vector).
The rows in the matrices, \code{supp[[i]][l,]}, \code{l in 1:Nsupp} represents the indices of the knots that are the endpoints of the intervals in the support sets. 
Each of the support set is represented as a union of disjoint \code{Nsupp} intervals, with knots as the endpoints. Outside the set (support), the spline vanishes. 
Each matrix in this list is ordered so the rows closer to the top correspond to the intervals closer to the LHS end of
the support.}

\item{\code{der}}{list (of matrices); a list of the length \code{N} containing
\code{sum(supp[[i]][,2]-supp[[i]][,1]+1) x (degree+1)} matrices, where \code{i} is the index running through the list.
Each matrix in the list includes the values of the derivatives at the knots in the support of the corresponding spline.}

\item{\code{taylor}}{\code{(n+1) x (degree+1)}, if \code{equid=FALSE}, or \code{1 x (degree+1)}
if \code{equid=TRUE},  columnwise vectors  of the Taylor expansion coefficients at the knots; 
Vectors instead of matrices are recognized properly.
The knot and order dependent matrix of rows of coefficients used in the Taylor expansion of splines.
Once evaluated it can be used in computations for any spline of the given order over the given knots.
The columns of this matrix are used for evaluation of the values of the splines in-between knots,
see the references for further details.}

\item{\code{type}}{string, one of the following character strings: \code{bs},\code{gsob},\code{twob},\code{dspnt},\code{spnt},\code{sp}; The default is \code{sp} which 
indicates any unstructured collection of splines. The rest of the strings indicate different \emph{spline bases}: 
\itemize{
  \item \code{bs} for B-splines,
  \item \code{gsob} for Gram-Schmidt O-splines,
  \item \code{twob} for two-sided O-splines,
  \item \code{dspnt} for a fully dyadic splinet,
  \item \code{spnt} for a non-dyadic splinet.
}}

\item{\code{periodic}}{logical, indicates if the B-splines are periodic or not.}

\item{\code{epsilon}}{numeric (positive), an accuracy used to detect a problem with the conditions
required for the matrix of the derivatives (controls relative deviation from the conditions);}
}}

\section{References}{

Liu, X., Nassar, H., Podg\eqn{\mbox{\'o}}{o}rski, K. "Dyadic diagonalization of positive definite band matrices and efficient B-spline orthogonalization." Journal of Computational and Applied Mathematics (2022) <https://doi.org/10.1016/j.cam.2022.114444>.


Podg\eqn{\mbox{\'o}}{o}rski, K. (2021) 
"\code{Splinets} -- splines through the Taylor expansion, their support sets and orthogonal bases." <arXiv:2102.00733>.

 Nassar, H., Podg\eqn{\mbox{\'o}}{o}rski, K. (2023) "Splinets 1.5.0 -- Periodic Splinets." <arXiv:2302.07552>
}

\examples{
#-------------------------------------------------------------#
#-------Generating an object from the class 'Splinets'--------#
#-------------------------------------------------------------#
#The most generic generation of an object of class 'Splinets':
sp=new("Splinets") #a generic format for 'Splinets' object
sp
#The most important SLOTs of 'Splinets' - the default values
sp@knots
sp@degree
sp@der
sp@supp

set.seed(5); n=13; xi=sort(runif(n+2)); xi[1]=0;xi[n+2]=1
sp@knots=xi #randomly assigned knots

#Changing the degree and intializing Taylor coefficients
ssp=new("Splinets",knots=xi,degree=2)
ssp@taylor

#Equidistant case
ssp=new("Splinets",knots=seq(0,1,1/(n+1)),degree=3)
ssp@taylor
ssp@equid
}
\seealso{
\code{\link{is.splinets}} for evaluation of a \code{Splinets}-object; \code{\link{construct}} for constructing a \code{Splinets}-object; 
\code{\link{plot,Splinets-method}} for plotting methods for \code{Splinets}-objects;
}
