% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rGClat.R
\name{rGClat}
\alias{rGClat}
\title{Generate Data from GC Spatial Regression Model with Lattice Spatial Effect}
\usage{
rGClat(
  n = n,
  alpha,
  beta0,
  beta,
  spatial = "ICAR",
  W = NULL,
  V = NULL,
  rho = 1,
  shapefile = NULL
)
}
\arguments{
\item{n}{Integer. The number of knots (or spatial units) for which the data should be generated. If a shapefile or adjacency matrix (`W`) is provided, this will be determined from those inputs.}

\item{alpha}{Numeric. The dispersion parameter of the Gamma-Count model.}

\item{beta0}{Numeric. The intercept term for the model.}

\item{beta}{Numeric vector. The regression coefficients (fixed effects) for the model.}

\item{spatial}{Character. Specifies the type of spatial dependency to use. Options are "ICAR" for Intrinsic Conditional Autoregressive, or "CAR" for Conditional Autoregressive.}

\item{W}{Optional matrix. The adjacency matrix for lattice data. If provided, it will be used to define spatial relationships between knots.}

\item{V}{Optional numeric. The variance of the spatial random effects for lattice data.}

\item{rho}{Optional numeric. The spatial correlation coefficient for the CAR model. Default is 1.}

\item{shapefile}{Optional. A shapefile defining the spatial relationships between knots. If provided, it will be used to define an adjacency matrix.}
}
\value{
A list containing the following components:
\describe{
  \item{covariate}{A matrix of covariates with the specified number of knots (`n`) and columns based on the length of `beta`.}
  \item{phi}{A vector of spatial random effects, generated based on the specified spatial dependency model (`spatial`).}
  \item{eta}{A vector representing the linear predictor, calculated as the dot product of the covariates and coefficients plus the spatial effects (`phi`).}
  \item{y}{A vector of simulated count data based on the GC model and the linear predictor (`eta`).}
  \item{ID}{A vector of knot IDs from 1 to `n`.}
}
}
\description{
This function generates spatially dependent count data based on the Gamma-Count (GC) spatial regression model.
It uses a specified spatial dependency model (either ICAR or CAR) and optional adjacency matrix or shapefile for spatial relationships.
The function returns a list containing the generated data and relevant information about the simulation.
}
\examples{
\donttest{
# Generate a random adjacency matrix for a 429x429 grid
W <- rAdj(429)

# Generate data from the GC spatial regression model with the specified parameters
data <- rGClat(n = 200, alpha = 1, beta0 = 0.3, beta = c(-0.5, 0.5),
spatial = "ICAR", W = W, V = 1)

# View the generated data
print(data)
}

}
