% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon.R
\name{varshannon}
\alias{varshannon}
\title{Estimated variance of Shannon's entropy.}
\usage{
varshannon(data)
}
\arguments{
\item{data}{A data matrix or vector, can be numeric, factor, character, ...
Alternatively, a marked \code{ppp} object.}
}
\value{
the estimated variance of Shannon's entropy.
}
\description{
This function estimates the variance of Shannon's entropy of a variable \eqn{X}.
}
\details{
\link{varshannon} estimates the
variance of the maximum likelihood estimator of Shannon's entropy given by
\link{shannon}. The variance is \deqn{V(H(X))=H(X)_2- H(X)^2}, where \eqn{H(X)_2} is
a version of Shannon's entropy (see \link{shannon}) where
the information function \eqn{\log(1/p(x_i))} is squared:
\deqn{H(X)_2=\sum p(x_i) \log(1/p(x_i))^2}.
The function is able to work with lattice data with missing data, as long as they are specified as NAs:
missing data are ignored in the computations.
}
\examples{
#NON SPATIAL DATA
varshannon(sample(1:5, 50, replace=TRUE))

#POINT DATA
data.pp=runifpoint(100, win=square(10))
marks(data.pp)=sample(c("a","b","c"), 100, replace=TRUE)
varshannon(marks(data.pp))

#LATTICE DATA
data.lat=matrix(sample(c("a","b","c"), 100, replace=TRUE), nrow=10)
varshannon(data.lat)

}
