% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moduleMetadata.R
\name{moduleMetadata}
\alias{moduleMetadata}
\alias{moduleMetadata,missing,character,character-method}
\alias{moduleMetadata,missing,character,missing-method}
\alias{moduleMetadata,ANY,ANY,ANY-method}
\title{Parse and extract module metadata}
\usage{
moduleMetadata(
  sim,
  module,
  path = getOption("spades.modulePath", NULL),
  defineModuleListItems = c("name", "description", "keywords", "childModules", "authors",
    "version", "spatialExtent", "timeframe", "timeunit", "citation", "documentation",
    "reqdPkgs", "parameters", "inputObjects", "outputObjects")
)

\S4method{moduleMetadata}{missing,character,character}(module, path, defineModuleListItems)

\S4method{moduleMetadata}{missing,character,missing}(module, defineModuleListItems)

\S4method{moduleMetadata}{ANY,ANY,ANY}(
  sim,
  module,
  path = getOption("spades.modulePath", NULL),
  defineModuleListItems = c("name", "description", "keywords", "childModules", "authors",
    "version", "spatialExtent", "timeframe", "timeunit", "citation", "documentation",
    "reqdPkgs", "parameters", "inputObjects", "outputObjects")
)
}
\arguments{
\item{sim}{A \code{simList} simulation object, generally produced by \code{simInit}.}

\item{module}{Character string. Your module's name.}

\item{path}{Character string specifying the file path to modules directory.
Default is to use the \code{spades.modulePath} option.}

\item{defineModuleListItems}{A vector of metadata entries to return values
about.}
}
\value{
A list of module metadata, matching the structure in \code{\link[=defineModule]{defineModule()}}.
}
\description{
Parse and extract module metadata
}
\examples{
## turn off code checking -- don't need it here
opts <- options("spades.moduleCodeChecks" = FALSE,
                "spades.useRequire" = FALSE)

path <- getSampleModules(tempdir())
sampleModules <- dir(path)
x <- moduleMetadata(sampleModules[3], path = path)

## using simList
if (require("SpaDES.tools", quietly = TRUE)) {
   mySim <- simInit(
      times = list(start = 2000.0, end = 2001.0, timeunit = "year"),
      params = list(
        .globals = list(stackName = "landscape")
      ),
      modules = list("caribouMovement"),
      paths = list(modulePath = path)
   )
   moduleMetadata(sim = mySim)
}

# turn code checking back on -- don't need it here
options(opts)
}
\seealso{
\code{\link[=defineModule]{defineModule()}}
}
\author{
Alex Chubaty
}
