% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilTesting.R
\name{WBC}
\alias{WBC}
\title{Oxidizable organic carbon (C) or Walkley-Black C in soil}
\usage{
WBC(W = W, Vk = Vk, Vb = Vb, Vs = Vs, Nk = Nk)
}
\arguments{
\item{W}{Mass of soil sample (g)}

\item{Vk}{Volume of potassium dichromate solution (mL)}

\item{Vb}{Volume of ferrous ammonium sulphate solution (mL) consumed in titration without soil (i.e., blank titration)}

\item{Vs}{Volume of ferrous ammonium sulphate solution (mL) consumed in titration with soil}

\item{Nk}{Normality of potassium dichromate solution}
}
\value{
WBC_pc - Oxidizable organic C or Walkley-Black C in soil (\%)
WBC_gkg - Oxidizable organic C or Walkley-Black C in soil (g/kg)
}
\description{
The oxidizable organic C or Walkley-Black C (WBC) in soil is obtained by this function based on the method described by Walkley and Black (1934).
}
\details{
Soil organic C is very important to soil fertility, nutrient cycling and C sequestration. Routine soil testing includes determination of oxidizable organic C as per the method described by Walkley and Black (1934). The oxidizable organic C mostly encompasses C present in partly decomposed organic matter and slightly the well decomposed organic matter in soil (Basak, 2000). The method suggested by Walkley and Black (1934) involves oxidation of soil organic C with an excess of standard (usually 1 N) potassium dichromate solution (usually, 10 mL for 1 g soil) in presence of concentrated sulphuric acid (20 mL). The unreacted potassium dichromate solution is titrated against freshly prepared ferrous ammonium sulphate solution to get the volume of potassium dichromate solution consumed in oxidizing soil organic C, from which the content of oxidizable organic C is calculated.
}
\examples{
with(data = df_WBC, WBC(W = Mass_Soil, Vk = Vol_Potassium_dichromate,
Vb = Vol_FAS_Blank, Vs = Vol_FAS_Soil, Nk = Normality_Potassium_dichromate))

}
\references{
Basak RK (2000) Soil Testing and Recommendation: A Text Book. Kalyani Publishers, New Delhi, India.

Walkley AJ, Black CA (1934) An estimation of the Degtjareff method for determining soil organic matter and a proposed modification of the chromic acid titration method. Soil Science 37, 29–38. doi:10.1097/00010694-193401000-00003
}
