% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soil_cover.R
\name{soil_cover}
\alias{soil_cover}
\title{Estimate soil cover by plants and residues}
\usage{
soil_cover(var_MGMT_data, extended.output = FALSE)
}
\arguments{
\item{var_MGMT_data}{a \code{management_df} that contains the management information}

\item{extended.output}{an optional logical value.
\itemize{
\item If FALSE, soil cover days are aggregated by year.
\item If TRUE, a soil_cover_tibble with daily resolution is returned.
\item Default value is FALSE
}}
}
\value{
\itemize{
\item By default, a tibble with soil cover days by year is returned.
\item If extended.output = TRUE, an object of the class \code{soil_cover_tibble}
with daily resolution is returned.
}
}
\description{
Derives the days where soil cover by living plants or resiudes is \verb{>=30\%}.
}
\details{
The function takes a \code{management_df} as input and returns soil cover
days per year in the \code{management_df.}
Alternatively, it can return a \code{soil_cover_tibble} with daily resolution
of the estimated soil cover.

The function calculates plant soil cover with the \code{\link[=plant_cover]{plant_cover()}} function
and the soil coverage by residues.

The residue mass is dependent on the residue supply by crops,
its decay and its incorporation by tillage operations
\insertCite{buchi2016}{SoilManageR}.

Residue supply is estimated with the yield dependent
residue C \code{C_input_straw} provided by the function \code{\link[=C_input_crops]{C_input_crops()}} and
a C content of \eqn{450 \ [mgC/gDM]}.
If residues are removed, the removed residue mass is subtracted.

Residue decay is calculated with the formula of
\insertCite{steiner1999;textual}{SoilManageR}:
\deqn{M_t = M_{t-1} * (1 - k_{decay})}
Where \eqn{M_{t-1}} is the residue mass of the prior day \eqn{[g/m^2]} and
\eqn{k_{decay}} is the daily decay rate that was assumed to be
\code{0.028} \eqn{g/g}, the average decomposition rate of winter wheat straw
\insertCite{steiner1999}{SoilManageR}.

Residue incorporation by tillage was estimated with the operation-specific
burial coefficient extracted from the RUSLE2 database
\insertCite{RUSLE2}{SoilManageR} that are provided in the
look-up-table \code{STIR_values_LUT}.

Residue mass is translated into percentage of soil cover
by the formula of \insertCite{steiner2000;textual}{SoilManageR}:
\deqn{cover_{residues} = (1-e^{-k(M)})* 100 \%}
Where \eqn{M} is the residue mass \eqn{[g/m^2]} and \eqn{k} is a cover
coefficient \eqn{[m^2/g]}. \eqn{k} was assumed to be \code{0.0175}
\insertCite{steiner2000}{SoilManageR}.
}
\examples{
\donttest{
  #example that returns annual soil cover days by plants and residues
  soil_cover(EXAMPLE_data)

  #example that returns a soil_cover_tibble
  soil_cover(EXAMPLE_data, extended.output = TRUE)
}

}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
\item \code{\link[=calculate_indicators]{calculate_indicators()}} to calculate all management indicators
for a \code{management_df}
\item \code{\link[=calculate_soil_cover_tibble]{calculate_soil_cover_tibble()}} a helper function that calculates the soil cover tibble
\item \code{\link[=plant_cover]{plant_cover()}} for more detail on the plant cover function
\item \code{\link[=plot.soil_cover_tibble]{plot.soil_cover_tibble()}} for plotting the \code{soil_cover_tibble}
\item \code{STIR_values_LUT} for tillage operation specific burial coefficients
}
}
