% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C_input_crops.R
\name{C_input_crops}
\alias{C_input_crops}
\title{Estimate C inputs by crops}
\usage{
C_input_crops(
  crop,
  crop_product = NA,
  crop_residue = NA,
  harvest_index = NA,
  variable_harvest_index = NA,
  HI_intercept = NA,
  HI_slope = NA,
  shoot_root_ratio = NA,
  root_exudation_factor = NA,
  Cc_product = 450,
  Cc_residue = 450,
  Cc_root = 450,
  straw.removal = NA,
  fixed_belowground_input = NA,
  fixed_C_input_root = NA,
  return.comment = FALSE
)
}
\arguments{
\item{crop}{Crop type. Must match predefined list (see \code{C_input_crops_LUT})}

\item{crop_product}{(optional) Dry weight of the exported product, i.e. yield. Default value is taken from table (tDM/ha)}

\item{crop_residue}{(optional) Dry weight of the residues of the main crop (e.g., straw, sugar beet leaves) (tDM/ha)}

\item{harvest_index}{(optional) Ratio of the product to the total above ground biomass}

\item{variable_harvest_index}{(optional) Logical value that is TRUE if the variable harvest index assumptions of Fan et al. (2017) are to be applied (TRUE / FALSE)}

\item{HI_intercept}{(optional) Intercept of the variable harvest index. Values provided by Fan et al. (2017)}

\item{HI_slope}{(optional) Slope of the variable harvest index. Values provided by Fan et al. (2017) (ha/tDM)}

\item{shoot_root_ratio}{(optional) Ratio of the total above ground biomass to the root biomass}

\item{root_exudation_factor}{(optional) Ratio of the root exudated C to the C in the root biomass}

\item{Cc_product}{(optional) C concentration in the exported product. Default value is 450 (gC/kgDM)}

\item{Cc_residue}{(optional) C concentration in the residues of the main crop. Default value is 450 (gC/kgDM)}

\item{Cc_root}{(optional) C concentration in the roots. Default value is 450 (gC/kgDM)}

\item{straw.removal}{(optional) Logical value that is TRUE if straw is removed at harvest.
\itemize{
\item When NA then SR value from table is take
\item When TRUE SS is 1
\item When FALSE SS is 0.
\item Default value is NA
}}

\item{fixed_belowground_input}{(optional) Logical value that is TRUE if fixed below ground Carbon inputs are to be assumed (e.g. for temporary leys) (TRUE / FALSE)}

\item{fixed_C_input_root}{(optional) amount of root C that is assumed if fixed_belowground_input is TRUE (kgC/ha)}

\item{return.comment}{(optional) logical value if comment are returned or not. Default = FALSE (TRUE/FALSE)}
}
\value{
a tibble with the following parameters:
\itemize{
\item C_input_product: Estimated soil carbon input from product (e.g. damaged patatos) (kgC/ha),
\item C_input_straw: Estimated soil carbon input by straw or other residues (kgC/ha),
\item C_input_root: Estimated soil carbon input by roots (kgC/ha),
\item C_input_exudate: Estimated soil carbon input by roots (kgC/ha),
\item C_input_total: Total estimated Soil carbon input, sum of C_input_straw, C_input_root, C_input_exudate (kgC/ha),
\item comment (optional): comment on the derived values
}
}
\description{
Calculates the estimated carbon (C) input into the soil system by harvested main crops.
}
\details{
The annual C input by crops were estimated based on crop type and crop yield
with the allometric functions of \insertCite{bolinder2007;textual}{SoilManageR}:

\deqn{ 
C_{Product} = Product * CC_{Product}
}
\deqn{ 
C_{Straw} = {Product}* \frac{1 - HI}{HI} * CC_{Straw}
}
\deqn{  
C_{Root} = \frac{Product}{SRR*HI} * CC_{Root}
}
\deqn{  
C_{Exudates} = C_{Root} * REF
}

Where \eqn{C} is the C per fraction (in kgC/ha) and \eqn{CC} is the C
content of given fraction (kgC/tDM). \eqn{Prodcuct} is the dry matter
yield of a crop in tDM/ha, \eqn{HI} is the harvest index
(ratio of product total of product and straw), \eqn{SRR} is the
ratio of the shoot biomass (product and straw) to the root biomass,
and \eqn{REF} is the root exudation factor
(i.e., the ratio of the C exudated by the roots
to the C in the root biomass). All fractions are multiplied with
a crop and fraction specific \eqn{S}-factor that determines the share
of the fraction that is returned to the soil.

If not mentioned otherwise parameters were taken from the
publications of \insertCite{bolinder2007;textual}{SoilManageR},
\insertCite{keel2017;textual}{SoilManageR} or
\insertCite{wuest2020;textual}{SoilManageR}.
Parameters for potatoes and sugar beets were derived from
\insertCite{bolinder2015;textual}{SoilManageR}
For temporary leys we assumed yield-independent annual
\eqn{C_{Root}} of 1.5 MgC/ha and a \eqn{REF} of 0.5
\insertCite{taghizadeh-toosi2020}{SoilManageR}.
Furthermore, like \insertCite{wuest2020;textual}{SoilManageR}, the
belowground C input (\eqn{C_{Root} + C_{Exudates}}) of corn maize,
silage maize and cereals were fixed to 0.46 MgC/ha, 1.1 MgC/ha and
0.6 MgC/ha respectively, based on the values from
\insertCite{hirte2018;textual}{SoilManageR}.
Additionally, we applied the yield dependent harvest index
\eqn{(HI = Intercept + Product * Slope)} proposed by
\insertCite{fan2017;textual}{SoilManageR} for cereals, faba beans,
peas, corn, rapeseed, and soybeans.

Reference yields were derived from the Swiss fertilizer recommendations
\insertCite{GRUD2017_ch8;textual}{SoilManageR}.

All default values can be found in the look-up-table \code{C_input_crops_LUT}.
}
\examples{
#example without yield information, default yield is assumed
C_input_crops("wheat, winter")

#example with yield information and straw retention
C_input_crops("barley, spring", crop_product = 4.5, straw.removal = FALSE)

#example with more information
C_input_crops("barley, spring", crop_product = 4.5, harvest_index = 0.4,
              shoot_root_ratio = 2.4, root_exudation_factor = 0.5)

#example with variable harvest index
C_input_crops("barley, spring", crop_product = 4.5, variable_harvest_index = TRUE,
              HI_intercept = 0.35, HI_slope = 0.015, shoot_root_ratio = 2.4,
              root_exudation_factor = 0.5)

#example with fixed below ground input
C_input_crops("maize, silage", crop_product = 18.5, 
              fixed_belowground_input = TRUE, fixed_C_input_root = 1500,
              root_exudation_factor = 0.3) 
}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
\item \code{\link[=C_input]{C_input()}} to calculate C inputs for a \code{management_df}
\item \code{\link[=C_input_cover_crops]{C_input_cover_crops()}} to calculate C input for cover crops
\item \code{\link[=CN_input_amendments]{CN_input_amendments()}} to calculate C (and N) inputs for organic amendments
\item \code{\link[=C_input_crops_LUT]{C_input_crops_LUT()}} for the look-up-table for crop reference values
}
}
