% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_kupf.R
\name{read.kupf}
\alias{read.kupf}
\title{Read Evaporation Experiment data from ku-pf Apparatur}
\usage{
read.kupf(
  path,
  colnames.out = c("ts", "tens.up", "tens.low", "weight"),
  firstrow.char = "Date/Time\\tTension top\\tTension bottom\\tWeight",
  format.time_stamp = "\%d.\%m.\%Y \%H:\%M:\%S",
  tz.time_stamp = "GMT",
  ...
)
}
\arguments{
\item{path}{path to ku-pf files (character)}

\item{colnames.out}{colnames of output (default: c('ts', 'tens.up', 'tens.low', 'weight'))}

\item{firstrow.char}{character in first row of ku-pf files (default: 'Date/Time    Tension top    Tension bottom    Weight') (see details)}

\item{format.time_stamp}{POSIXct format of the time stamp column (column 1, here named 'ts') (see \code{\link{strptime}})}

\item{tz.time_stamp}{time zone of the time stamp column (column 1, here named 'ts') (default: 'GMT') (see \code{\link{as.POSIXct}})}

\item{...}{arguments to \code{\link{list.files}}}
}
\value{
list of the class dataSEM containing data.tables as list elements.
}
\description{
Reads multiple ku-pf Apparatur files from a directory and returns them as list of data.tables.
}
\details{
\describe{\item{input file format:}{The standard file format of ku-pf files looks like: \cr
\cr
Date/Time	Tension top	Tension bottom	Weight \cr
kPa	kPa	g \cr
01.11.2017 14:11:16	-0.48	-0.15	969.02 \cr
01.11.2017 14:21:16	-0.47	-0.14	969.00 \cr
01.11.2017 14:31:16	-0.46	-0.13	968.98 \cr
\cr
If the first row of the ku-pf files differs to the expression used here ('Date/Time	Tension top	Tension bottom	Weight"),
it can be set with firstrow.char. \cr}}
\describe{\item{sample_info:}{File names are added as attribut to the output (attr(out, 'sample_info')). \cr
\cr
The ku-pf software gives the possibility to add
sample spezific information in the first row of the file. Depending on the input the ku-pf files than look: \cr
\cr
sample_name;project \cr
Date/Time	Tension top	Tension bottom	Weight \cr
kPa	kPa	g \cr
01.11.2017 14:11:16	-0.48	-0.15	969.02 \cr
01.11.2017 14:21:16	-0.47	-0.14	969.00 \cr
01.11.2017 14:31:16	-0.46	-0.13	968.98 \cr
\cr
- For this case the first line is added as attribute to the output (attr(out, 'sample_info')$info) \cr
}}
}
\author{
Ullrich Dettmann
}
