#' Load TIF File of John Snow's 1854 Map
#'
#' This function loads the included .tif file using terra.
#'
#' @return A SpatRaster object.
#' @export
#'
#' @examples
#' tif <- load_map()

load_map <- function() {
  url <- "https://raw.githubusercontent.com/niamhmimnagh/JohnSnowCholera/main/Snow-cholera-map.tif.zip"  # URL of the zipped file
  zipfile <- tempfile(fileext = ".zip")  # Temporary zip file location
  tif_dir <- tempdir()  # Temporary directory to extract files

  # Download the zip file
  utils::download.file(url, zipfile, mode = "wb")

  # Unzip the file
  utils::unzip(zipfile, exdir = tif_dir)

  # Find the extracted .tif file
  tif_file <- list.files(tif_dir, pattern = "\\.tif$", full.names = TRUE)

  # Check if a .tif file was found
  if (length(tif_file) == 0) {
    stop("No .tif file found in the extracted contents.")
  }

  # Load the .tif file as a raster
  terra::rast(tif_file[1])
}
