% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fFitSmithWilsonYieldCurve.R
\name{fFitSmithWilsonYieldCurve}
\alias{fFitSmithWilsonYieldCurve}
\title{Construct the Smith-Wilson yield curve}
\usage{
fFitSmithWilsonYieldCurve(
  TimesVector,
  CashflowMatrix,
  MarketValueVector,
  ufr,
  alpha
)
}
\arguments{
\item{TimesVector}{A vector of all cashflow times}

\item{CashflowMatrix}{A matrix of all cashflows, instruments in rows, times in columns}

\item{MarketValueVector}{A vector of market values of the insturments}

\item{ufr}{The Ultimate Forward Rate (UFR) of the Smith-Wilson kernel}

\item{alpha}{The rate of reversion of forward rates to the UFR in the Smith-Wilson kernel}
}
\value{
a list containing:
\itemize{
 \item "P" a function of time which gives the ZCB price to that term 
 \item "xi" the vector of weights applied to the kernel functions to obtain the ZCB price 
 \item "K" the (compound) kernel vector 
}
}
\description{
Constructs the SmithWilson ZCB function based on the given market inputs and parameter choices
}
