% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy_SlidingWindows.R
\name{entropy.SlidingWindows}
\alias{entropy.SlidingWindows}
\title{Approximate entropy with sliding windows.}
\usage{
entropy.SlidingWindows(y, w = 99, k = 4, dim = 2, r = 0.5, lag = 1)
}
\arguments{
\item{y}{A vector containing univariate time series.}

\item{w}{An integer value indicating the window size \eqn{w < length(y)}.
If \eqn{w = length(y)}, will be computed the function will not slide.}

\item{k}{An integer value indicating the boundary of the division \eqn{(N/k)}.
The smallest value of \eqn{k} is \eqn{4}.}

\item{dim}{The dimension of given time series. See TSEntropies package.}

\item{r}{The radius of searched areas. See TSEntropies package.}

\item{lag}{The downsampling. See TSEntropies package.}
}
\value{
A list contaning "w", "ApEn", "FastApEn".
}
\description{
This function computes approximate entropy of a univariate time series  with sliding windows approach.
}
\details{
This function return the list with time series sliding windows.
}
\examples{
y <- rnorm(100)
entropy.SlidingWindows(y, w=99, k=4, dim=2, r=.2,lag=1)

}
\references{
Pincus, S.M. (1991). Approximate entropy as a measure of system complexity. Proc. Natl. Acad. Sci. USA, Vol. 88, pp. 2297–2301. doi="doi.org/10.1073/pnas.88.6.2297".
}
