% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfa_SlidingWindows.R
\name{dfa.SlidingWindows}
\alias{dfa.SlidingWindows}
\title{Detrended Fluctuation Analysis with sliding windows.}
\usage{
dfa.SlidingWindows(y, w = 98, k = 10, npoints = 15)
}
\arguments{
\item{y}{A vector containing univariate time series.}

\item{w}{An integer value indicating the window size \eqn{w < length(y)}.
If \eqn{w = length(y)}, will be computed the function will not slide.}

\item{k}{An integer value indicating the boundary of the division \eqn{(N/k)}.
The smallest value of \eqn{k} is \eqn{4}.}

\item{npoints}{The number of different time scales that will be used to estimate the Fluctuation function in each zone. See nonlinearTseries package.}
}
\value{
A list contaning "w", "alpha_dfa", "se_alpha_dfa", "r2_alpha_dfa".
}
\description{
This function generates scaling exponents (long-range correlations) of a univariate time series with sliding windows approach.
}
\details{
This function include following measures: alpha_dfa, se_alpha_dfa, r2_alpha_dfa.
}
\examples{
y <- rnorm(100)
dfa.SlidingWindows(y,w=99,k=10,npoints=15)

}
\references{
GUEDES, E.F.;FERREIRA, P.;DIONISIO, A.; ZEBENDE,G.F. An econophysics approach to study the effect of BREXIT referendum on European Union stock markets. PHYSICA A, v.523, p.1175-1182, 2019. doi = "doi.org/10.1016/j.physa.2019.04.132".

FERREIRA, P.; DIONISIO, A.;GUEDES, E.F.; ZEBENDE, G.F. A sliding windows approach to analyse the evolution of bank shares in the European Union. PHYSICA A, v.490, p.1355-1367, 2018. doi = "doi.org/10.1016/j.physa.2017.08.095".
}
