% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ss.data.bills}
\alias{ss.data.bills}
\title{Errors in bills data set}
\format{
A data frame with 32 observations on the following 3 variables.
\describe{ \item{nbill}{a numeric vector identifying a given bill}
\item{clerk}{a character vector for the clerk responsible for the
bill} \item{errors}{a character vector with the number of errors in
the bill} }
}
\source{
Table 6.1 in the reference below.
}
\usage{
data("ss.data.bills")
}
\description{
This data set contains the number of errors detected in a set of bills and
the name of the person in charge of the bill.
}
\details{
This data set illustrates concepts in the book ``Quality Control with R''.
}
\examples{

data(ss.data.bills)
str(ss.data.bills) 
barplot(table(ss.data.bills$clerk), 
    main = "number of invoices")
aggregate(errors ~ clerk, ss.data.bills, sum)

}
\references{
Cano, E.L. and Moguerza, J.M. and Prieto Corcoba, M. (2015)
\emph{Quality Control with R. An ISO Standards Approach}. Springer.
}
\keyword{datasets}
