% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleSize_Mielke.R
\name{power_dom}
\alias{power_dom}
\title{Power Calculation for Difference of Means (DOM) Hypothesis Test}
\usage{
power_dom(
  seed,
  mu_test,
  mu_control,
  sigma_test,
  sigma_control,
  N_test,
  N_control,
  lb,
  ub,
  alpha = 0.05,
  nsim = 10000
)
}
\arguments{
\item{seed}{Integer. Seed for reproducibility.}

\item{mu_test}{Numeric. Mean of the test group.}

\item{mu_control}{Numeric. Mean of the control group.}

\item{sigma_test}{Numeric. Standard deviation of the test group.}

\item{sigma_control}{Numeric. Standard deviation of the control group.}

\item{N_test}{Integer. Sample size of the test group.}

\item{N_control}{Integer. Sample size of the control group.}

\item{lb}{Numeric. Lower bound for the equivalence margin.}

\item{ub}{Numeric. Upper bound for the equivalence margin.}

\item{alpha}{Numeric. Significance level (default = 0.05).}

\item{nsim}{Integer. Number of simulations (default = 10,000).}
}
\value{
Numeric. Estimated power (probability between 0 and 1).
}
\description{
Computes the statistical power for testing the difference of means (DOM) between two groups using Monte Carlo simulations. The power is estimated based on specified sample sizes, means, standard deviations, and significance level.
}
