% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.CopApprox.R
\name{plot.CopApprox}
\alias{plot.CopApprox}
\title{Plot the histogram density approximation to a copula}
\usage{
\method{plot}{CopApprox}(
  x,
  type = c("rgl", "original"),
  col = if (type == "rgl") "#cccccc" else grey.colors(100, start = 0, end = 0.8),
  qcut = 0.95,
  cut,
  alpha = 1,
  topcol = "#ff0000",
  sidecol = "#aaaaaa",
  linecol = "#000000",
  ...
)
}
\arguments{
\item{x}{an object of \code{\link{class}} \sQuote{CopApprox}.}

\item{type}{specifies the type of plot to produce.  Possible values are \dQuote{\code{rgl}} and \dQuote{\code{original}}; see \sQuote{Details}. Can be abbreviated.}

\item{col}{colour(s) to be used; see \sQuote{Details}.}

\item{qcut, cut}{used if \code{type} is \dQuote{\code{rgl}}; see \sQuote{Details}.}

\item{alpha, topcol, sidecol, linecol}{used if \code{type} is \dQuote{\code{rgl}}; see \sQuote{Details}.}

\item{\dots}{used if \code{type} is \dQuote{\code{original}}; see \sQuote{Details}.}
}
\value{
\code{NULL} is returned \link[=invisible]{invisibly}.
}
\description{
Plots the histogram density approximation to a copula as determined by \code{\link{GetApprox}}.  Currently works only for bivariate copulae.
}
\details{
If \code{type} is \dQuote{\code{original}} then plots are produced of the kind shown in Tajvidi and Turlach (2017).  In this case the dot arguments are passed to \code{\link{plot}} when the initial plot is created.  Thus, they can be used to set the main title, axes labels and so forth.  If the approximation is of type Approximation II, then argument \code{col} is used to colour the squares while they are plotted and filled via \code{\link{polygon}}.  For this, the ranks of the probability masses of the squares are mapped (linearly) onto the provided colours.

If \code{type} is \dQuote{\code{rgl}} then plots are used using \code{\link[rgl]{rgl}}.  The code used is based on the \sQuote{\code{hist3d}} demo of the \code{rgl} package.  The argument \code{col} sets the background colour of the plot.  Arguments \code{topcol} and \code{sidecol} are used to set the colour of the top and sides of the cuboids, and the edges of the cuboids are drawn using \code{linecol}.  Argument \code{alpha} sets the transparency.   Finally, as the heights of the cuboids can be large, in particular for extreme value copulae, their heights are truncated using either \code{cut} (absolute value) or \code{qcut} (corresponding quantile of all heights as determined by the \code{\link{quantile}} function).  After truncation, the heights are rescaled to be between 0 and 1, thus the unit on the \dQuote{z}-axis is meaningless.
}
\examples{
Cop <- NewMEVGumbelCopula(4)
CopApprox1 <- GetApprox(Cop, dim=2)
plot(CopApprox1)
plot(CopApprox1, type = "o")
CopApprox2 <- GetApprox(Cop, dim=2, type=2)
plot(CopApprox2)
plot(CopApprox2, type = "o", xlab = expression(u[1]), ylab = expression(u[2]))
plot(CopApprox2, type = "o", col = heat.colors(100))

}
\references{
Tajvidi, N. and Turlach, B.A. (2017). A general approach to generate random variates for multivariate copulae, \emph{Australian & New Zealand Journal of Statistics} \bold{60}(1): 140--155. \doi{10.1111/anzs.12209}.
}
\author{
Berwin A. Turlach \email{berwin.turlach@gmail.com}
}
\keyword{hplot}
