% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.gsa.R
\name{network.gsa}
\alias{network.gsa}
\title{Sample under the Generalized Sampling Approach}
\usage{
network.gsa(net, ntaxa, complete = TRUE, frac = 1, stochsampling = FALSE)
}
\arguments{
\item{net}{A network to sample phylogenies.}

\item{ntaxa}{The number of desired taxa.}

\item{complete}{If complete = TRUE, the tree with the extinct lineages is returned. If complete = FALSE, the extinct lineages are suppressed.}

\item{frac}{Sampling fraction: The proportion of extant tips included in the phylogeny (incomplete sampling).}

\item{stochsampling}{When \code{stochsampling=TRUE}: Each extant tip is included into the final tree with probability frac.}
}
\value{
A network with n extant taxa
}
\description{
Takes a phylogeny and samples a period where n lineages exist. This method properly samples n taxa under the GSA
}
\examples{
set.seed(10)
ssa_net <-sim.bdh.taxa.ssa(n=20,numbsim=1,
lambda=1,mu=0.2,
nu=0.25, hybprops = c(1/3,1/3,1/3),
hyb.inher.fxn = make.beta.draw(1,1),
)[[1]]
gsa_net<-network.gsa(ssa_net,5)


}
