% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_lowexp.R
\name{filter_lowexp}
\alias{filter_lowexp}
\title{filter_lowexp}
\usage{
filter_lowexp(so, t1 = 10, t2 = 0.9, t3 = 0.9)
}
\arguments{
\item{so}{a SiFINeT object}

\item{t1}{threshold for number of total edges connecting the feature node. Lower t1 leads to stricter filtering.}

\item{t2}{threshold for the proportion of positive edges. Lower t2 leads to stricter filtering.}

\item{t3}{threshold for the proportion of edges with features of same expression level. Lower t3 leads to stricter filtering.}
}
\value{
SiFINeT object with kset (kept index set) updated.
}
\description{
The function filters out genes with low expression rate and
high positive coexpression with genes of same expression level
}
\details{
When using only mean expression level as independent variable in quantile regression,
it is observed that genes with low expression level tend to have large positive \eqn{S_{ij}} with genes that have same median expression level.
To reduce the coexpression noise caused by low expression level, it is preferred to filter out genes which have large amount and high proportion of positive coexpressions with genes sharing same median expression level.
}
