% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ShinyTester.R
\name{ShinyDummyCheck}
\alias{ShinyDummyCheck}
\title{ShinyDummyCheck}
\usage{
ShinyDummyCheck(directory = ".", ui = "ui.R", server = "server.R")
}
\arguments{
\item{directory}{the directory or website containing the files for the Shiny App. Defaults to current working directory}

\item{ui}{a character vector size 1 containing the name of the UI files. defaults to "ui.R"}

\item{server}{a character vector size 1 containing the names of the SERVER file. defaults to "server.R"}
}
\value{
Returns a dataframe with the matchings b/w ui and server files. Also spawns them in VIEW mode.
The structure of the table is as follows:
- Item - The name of the asset that maybe should be on both server.R and ui.R
- SrvCall - the TYPE of object that you're saying this specific item is (in server.R)
- isOutput  - is a binary that will specify if in server.R you wrote just `item` or `output$item`
- VisualCall - is the TYPE of thingie you're trying to push the item into (in ui.R).
- Status - Compares the SrvCall to the VisualCall, also looks at isOutput and then applies some rules to figure out if it's probably ok or not.

The Status types that are currently being checked for are:
The conditions being checked are:
It's OK if:
- the server calls `render(.)` and the ui calls `Output(.)` (where . is the same Item). I also make exceptions for print==text and textoutput==verbatimtextoutput
- If the server calls a reactive block, the ui should not have that Item name

It's NOT ok if:
- the server is calling a non-reactive and the UI doesn't have it. (this causes false positive errors for things like `observe` etc...)
- the server is calling a reactive block and there IS something showing up on the ui
- you are trying to show a non-reactive block in the ui, but forgot to put `Output$` before the item name in the server
}
\description{
This function takes Shiny files themselves as inputs and tries to combine the different
assets presented in the ui and server files to see whether they match up.
}
\details{
For now, it only works where the server and ui files are seperate (ie, it doesn't work for `app.R` yet)

You can test with your own app, go to your shiny app, make that your
 working directory, and then type `ShinyDummyCheck()`
}
\examples{
ShinyDummyCheck(directory = system.file("example", package = "ShinyTester"))
}

