% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_err_orth.r
\name{mc_err_orth}
\alias{mc_err_orth}
\title{Function that propagates measurement uncertainty through model results}
\usage{
mc_err_orth(x, x_err, y, y_err, X, Y, MC = 1000)
}
\arguments{
\item{x}{Vector of \code{x} values of input data}

\item{x_err}{Vector of uncertainties on \code{x} values}

\item{y}{Vector of \code{y} values of input data}

\item{y_err}{Vector of uncertainties on \code{y} values}

\item{X}{Vector of modeled \code{X} values on which the uncertainty is
to be projected}

\item{Y}{Matrix of modeled \code{X} and \code{Y} values}

\item{MC}{Number of Monte Carlo simulations to apply for error propagation
Default = 1000}
}
\value{
A vector listing the standard deviations of propagated errors
propagated on all \code{X} values.
}
\description{
Function to propagate combined errors on \code{x} (= \code{Dsam}) and
\code{y} (= \code{Osam}) on the modeled X (= \code{D}) and Y
(= \code{d18Oc}) values by means of orthogonal projection of uncertainty
on \code{x} and \code{y} onto the model curve
}
\examples{
# Create dummy data for input
x <-  seq(1, 40, 1)
x_err <- rep(0.1, 40)
y <- sin((2 * pi * (seq(1, 40, 1) - 8 + 30 / 4)) / 30)
y_err <- rep(0.1, 40)
X <- seq(1.5, 39.5, 1)
Y <- cbind(seq(1, 39, 1), 0.9 * sin((2 * pi * (seq(1, 39, 1) - 9 +
    25 / 4)) / 25))
# Run function
result <- mc_err_orth(x, x_err, y, y_err, X, Y, 1000)
}
