% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align_sequences.R
\name{align_sequences}
\alias{align_sequences}
\title{Sequence Alignment}
\usage{
align_sequences(seq1, seq2, d, mismatch, match, method = "needleman")
}
\arguments{
\item{seq1}{First sequence to align.}

\item{seq2}{Second sequence to align.}

\item{d}{Gap penalty, should be negative.}

\item{mismatch}{Mismatch penalty, should be negative.}

\item{match}{Match score, should be positive.}

\item{method}{Name of alignment algorithm. Currently only supports "needleman".}
}
\value{
Object of class \code{alignment} representing the alignment result.
This object can be utilized with the \code{\link{plot.alignment}} function to visualize
the alignment matrix and the \code{\link{print.alignment}} function to display alignments
in the console.
}
\description{
Performs sequence alignment on two sequences by a user specified alignment method. As of
now, only the Needleman-Wunsch algorithm is supported.
}
\examples{
seq1 <- "GCATGCG"
seq2 <- "GATTACA"
# Run the Needleman-Wunsch algorithm
align_sequences(seq1, seq2, d = -1, mismatch = -1, match = 1)

}
\references{
For more details on the Needleman-Wunsch algorithm, see the \href{https://en.wikipedia.org/wiki/Needleman-Wunsch_algorithm}{wikipedia page}.
}
