% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin2resp.R
\name{bin2resp}
\alias{bin2resp}
\title{Binary Responses to Character Responses}
\usage{
bin2resp(rmat, to.data.frame = FALSE)
}
\arguments{
\item{rmat}{Binary matrix.
A binarized response matrix of verbal fluency or linguistic data}

\item{to.data.frame}{Boolean.
Should output be a data frame where participants are columns?
Defaults to \code{FALSE}.
Set to \code{TRUE} to convert output to data frame}
}
\value{
A list containing objects for each participant and their responses
}
\description{
Converts the binary response matrix into characters for each participant
}
\examples{
# Toy example
raw <- open.animals[c(1:10),-c(1:3)]

if(interactive())
{
  # Clean and prepocess data
  clean <- textcleaner(open.animals[,-c(1:2)], partBY = "row", dictionary = "animals")

  # Change binary response matrix to word response matrix
  charmat <- bin2resp(clean$responses$binary)
}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
