% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_setSeaSondeRCS_MUSIC_parameters}
\alias{seasonder_setSeaSondeRCS_MUSIC_parameters}
\title{Set MUSIC Parameters for a SeaSondeRCS Object}
\usage{
seasonder_setSeaSondeRCS_MUSIC_parameters(
  seasonder_cs_object,
  MUSIC_parameters = seasonder_defaultMUSIC_parameters()
)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing cross-spectral data and metadata.}

\item{MUSIC_parameters}{A numeric vector of parameters for the MUSIC algorithm. Defaults to the result of \code{seasonder_defaultMUSIC_parameters()}.}
}
\value{
The updated \code{SeaSondeRCS} object with the new MUSIC parameters stored in its MUSIC options.
}
\description{
This function updates the MUSIC algorithm parameters stored in a SeaSondeRCS object's
MUSIC data attribute. The parameters are updated in the MUSIC options under the
\code{MUSIC_parameters} field. Currently, no explicit validation of the provided parameters is performed.
}
\details{
The function assigns the provided \code{MUSIC_parameters} vector to the
\code{MUSIC_parameters} field within the \code{MUSIC_options} list, which is stored
in the object's \code{MUSIC_data} attribute. These parameters are used in various
steps of the MUSIC processing workflow.
}
