% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_setSeaSondeRCS_APM}
\alias{seasonder_setSeaSondeRCS_APM}
\title{Set APM for a SeaSondeRCS Object}
\usage{
seasonder_setSeaSondeRCS_APM(seasonder_cs_object, seasonder_apm_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object.}

\item{seasonder_apm_object}{An object representing the APM (Antenna Pattern Matrix or similar metadata)
to be assigned to the SeaSondeRCS object.}
}
\value{
The updated SeaSondeRCS object with the new APM attribute set.
}
\description{
This function assigns the provided APM object to the SeaSondeRCS object by setting its "APM" attribute.
(Note: Validation of the APM object is to be implemented.)
}
\details{
The function simply sets the "APM" attribute of the provided SeaSondeRCS object to the given
APM object. Further validation of the APM object should be performed (TODO).
}
\examples{
# Minimal example for seasonder_setSeaSondeRCS_APM
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
cs_obj <- seasonder_setSeaSondeRCS_APM(cs_obj, apm_obj)
print(attr(cs_obj, "APM"))
}
