% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_readSeaSondeCSFileHeaderV6}
\alias{seasonder_readSeaSondeCSFileHeaderV6}
\title{Read SeaSonde CS File Header V6}
\usage{
seasonder_readSeaSondeCSFileHeaderV6(
  specs,
  connection,
  endian = "big",
  prev_data = NULL
)
}
\arguments{
\item{specs}{A list of specifications for reading the file header. It should contain three main elements:
\code{nCS6ByteSize}, \code{block_spec}, and \code{blocks}, each containing further specifications for reading various parts of the header.}

\item{connection}{A connection object to the SeaSonde CS file.}

\item{endian}{The byte order for reading the file. Default is "big".}

\item{prev_data}{Previous data, if any, that might affect the current reading. Default is NULL.}
}
\value{
A list containing the read data, organized based on the block keys.
}
\description{
This function reads the header of a SeaSonde CS File Version 6.
It sequentially reads blocks based on the provided specifications and returns the read data.
}
\section{Condition Management}{

This function utilizes the \code{rlang} package to manage conditions and provide detailed and structured condition messages:

\strong{Condition Classes}:
\itemize{
\item \code{seasonder_v6_block_transformacion_skipped}: Triggered when a transformation for a specific block is skipped.
\item \code{seasonder_v6_transform_function_error}: Triggered when there's an error while applying the transformation function for a V6 header block.
\item \code{seasonder_v6_skip_block_error}: Triggered when there's an error while skipping a block.
}

\strong{Condition Cases}:

The following are the scenarios when errors or conditions are raised:

\itemize{
\item Transformation Failure: If there's a recognized block key and the transformation function associated with it fails.
\item Error in Transformation Function Application: If there's an error while applying the transformation function for a recognized V6 header block.
\item Error in Skipping Block: If there's an error while skipping a block when the block key is not recognized.
}

\strong{Restart Options}:

The function provides the following restart option:

\code{seasonder_v6_skip_transformation}: This restart allows users to skip the transformation for a specific block and instead return the provided value.

\strong{Effects of Restart Options}:

Using the \code{seasonder_v6_skip_transformation} restart:
\itemize{
\item The error message gets logged.
\item The transformation that caused the error gets skipped.
\item The provided value for that block is returned.
}

Proper error management ensures the integrity of the reading process and provides detailed feedback to users regarding issues and potential resolutions.
}

\seealso{
\code{\link{seasonder_check_specs}}
\code{\link{seasonder_readSeaSondeCSFileBlock}}
\code{\link{readV6BlockData}}
\code{\link{seasonder_v6_skip_transformation}}
}
