% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_initCSDataStructure}
\alias{seasonder_initCSDataStructure}
\title{Initialize Cross-Spectra Data Structure for SeaSondeR}
\usage{
seasonder_initCSDataStructure(nRanges, nDoppler)
}
\arguments{
\item{nRanges}{Integer, number of range cells in the radar measurement.
Specifies the number of rows in each matrix.}

\item{nDoppler}{Integer, number of Doppler bins in the radar measurement.
Specifies the number of columns in each matrix.}
}
\value{
A list containing matrices for different cross-spectra components:
\itemize{
\item \code{SSA1}: Matrix for SSA1 component, filled with \code{NA_real_}.
\item \code{SSA2}: Matrix for SSA2 component, filled with \code{NA_real_}.
\item \code{SSA3}: Matrix for SSA3 component, filled with \code{NA_real_}.
\item \code{CS12}: Matrix for CS12 component, complex numbers with \code{NA_real_} real and imaginary parts.
\item \code{CS13}: Matrix for CS13 component, complex numbers with \code{NA_real_} real and imaginary parts.
\item \code{CS23}: Matrix for CS23 component, complex numbers with \code{NA_real_} real and imaginary parts.
\item \code{QC}: Quality control matrix, filled with \code{NA_real_}.
}s
}
\description{
This function initializes a data structure for storing cross-spectra data
related to SeaSonde radar measurements. It creates a list of matrices,
each corresponding to different components of the SeaSonde data.
}
