% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_getSeaSondeRCS_MUSIC_nDopplerCells}
\alias{seasonder_getSeaSondeRCS_MUSIC_nDopplerCells}
\title{Retrieve the Interpolated Number of Doppler Cells for MUSIC}
\usage{
seasonder_getSeaSondeRCS_MUSIC_nDopplerCells(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing metadata and configurations
related to MUSIC data processing.}
}
\value{
An integer representing the number of Doppler cells adjusted by the
Doppler interpolation factor.
}
\description{
This function calculates the interpolated number of Doppler cells for the MUSIC
data in a given \code{SeaSondeRCS} object. It applies a Doppler interpolation factor
to the original number of Doppler cells.
}
\details{
The function performs the following steps:
\enumerate{
\item Retrieves the total number of Doppler cells using \code{seasonder_getnDopplerCells}.
\item Retrieves the Doppler interpolation factor using \code{seasonder_getSeaSondeRCS_MUSIC_doppler_interpolation}.
\item Multiplies the number of Doppler cells by the interpolation factor to compute
the interpolated number of Doppler cells.
}
}
\seealso{
\code{\link{seasonder_getnDopplerCells}} to obtain the base number of Doppler cells.
\code{\link{seasonder_getSeaSondeRCS_MUSIC_doppler_interpolation}} to retrieve the Doppler interpolation factor.
}
