% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_getSeaSondeRCS_MUSIC}
\alias{seasonder_getSeaSondeRCS_MUSIC}
\title{Retrieve MUSIC Data from a SeaSondeRCS Object}
\usage{
seasonder_getSeaSondeRCS_MUSIC(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing MUSIC data as an attribute.}
}
\value{
The MUSIC data structure, typically a data frame or tibble with MUSIC results.
}
\description{
This function extracts the MUSIC data structure from a SeaSondeRCS object.
}
\details{
If the MUSIC data does not exist in the object, the function initializes it via \code{seasonder_initSeaSondeRCS_MUSIC()}.
}
\examples{
# Minimal example for seasonder_getMUSIC
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
music_data <- seasonder_getSeaSondeRCS_MUSIC(cs_obj)
print(music_data)
}
