% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getSeaSondeRCS_APM}
\alias{seasonder_getSeaSondeRCS_APM}
\title{Retrieve the APM Attribute from a SeaSondeRCS Object}
\usage{
seasonder_getSeaSondeRCS_APM(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object.}
}
\value{
The value of the "APM" attribute from the SeaSondeRCS object.
}
\description{
This function extracts the APM (Antenna Pattern Matrix or similar metadata) attribute from
a SeaSondeRCS object. This attribute is stored as an attribute named "APM" within the object.
}
\details{
The function uses \code{attr(..., exact = TRUE)} to ensure that the correct attribute is retrieved.
}
\examples{
# Create a minimal SeaSondeRCS object
cs_obj <- structure(list(data = list(a = 1, b = 2)), class = "SeaSondeRCS")
apm_value <- seasonder_getSeaSondeRCS_APM(cs_obj)
print(apm_value)
}
