% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getRadarWaveNumber}
\alias{seasonder_getRadarWaveNumber}
\title{Calculate the Radar Wave Number}
\usage{
seasonder_getRadarWaveNumber(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing the necessary data
to compute the radar wavelength.}
}
\value{
A numeric value representing the radar wave number \eqn{k} in
radians per meter.
}
\description{
This function computes the radar wave number \eqn{k} for a SeaSonde radar
system based on its wavelength. The wave number represents the spatial frequency
of the radar wave.
}
\details{
The radar wave number \eqn{k} is calculated using the formula:
\eqn{k = \frac{2 \pi}{\lambda}}
where:
\itemize{
\item \eqn{\lambda} is the radar wavelength in meters, calculated using
\code{\link{seasonder_getRadarWaveLength}}.
\item \eqn{2 \pi} represents the relationship between the wavelength and wave number.
}

The wave number is an essential parameter for analyzing radar signals and
their interaction with the medium being measured.
}
\seealso{
\code{\link{seasonder_getRadarWaveLength}} to compute the radar wavelength.
}
